#include "keycodes.as"
#include "peer.as"
#include "game.as"
#include "bullet.as"

Game @game = null;
Input input;

enum NetworkMessages
{
	ID_DISCONNECTION_NOTIFICATION = 21,
	ID_CONNECTION_LOST = 22,
	ID_NEW_PEER_JOINED = 150,	// When a new player joins, it sends this to the server
	ID_NEW_PEER_SYNCH,
	ID_PEER_DISCONNECTED,
	ID_PLAYER_SETUP,	// Called when a new player is initialised
	ID_PLAYER_UPDATE,	// Called to update other players - When it is our player, the player is corrected
	ID_PLAYER_INPUT,	// Sent to server
	ID_PLAYER_HEALTH,	// Called to update Player's health
	ID_PLAYER_DIED,
	ID_BULLET_FIRED		// Sent across when a bullet is fired
}

int main()
{
	game.OnLoop();
	return 1;
}

void OnLoad()
{
	Game g;
	@game = @g;
	
	//LoadShapeSet("basic");
	LoadWorld("deneme");
	
	/*CreateStaticAsset("Coolie", vec2(4,3));
	Asset @as = CreateStaticAsset("Coolie", vec2(2,6));
	as.SetRotation(1.5f);
	CreateStaticAsset("Foursided", vec2(4,7));
	CreateStaticAsset("Circle 5", vec2(8,6));*/
	
	AddPacketHandler("NewPeerJoined", NetworkMessages::ID_NEW_PEER_JOINED);
	AddPacketHandler("PlayerSetup", NetworkMessages::ID_PLAYER_SETUP);
	AddPacketHandler("PlayerInput", NetworkMessages::ID_PLAYER_INPUT);
	AddPacketHandler("BulletFired", NetworkMessages::ID_BULLET_FIRED);
	AddPacketHandler("DisconnectionNotification", NetworkMessages::ID_DISCONNECTION_NOTIFICATION);
	AddPacketHandler("DisconnectionNotification", NetworkMessages::ID_CONNECTION_LOST);
}
void NewPeerJoined(uint8 MessageID, uint64 guid, BitStream bit)	// This will be only received from a single client, when it first connects.
{
	print("New peer joined!\n");
	Peer newPeer;
	newPeer.guid = guid;
	uint64 tmp;
	string peerName;
	bit.IgnoreBytes(1);
	bit.Read(tmp);
	bit.ReadCompressed(newPeer.peerName);
	
	BitStream stream;
	stream.Write(uint8(NetworkMessages::ID_NEW_PEER_SYNCH));
	stream.Write(game.connectedPeers.length());
	for (uint t = 0; t < game.connectedPeers.length(); t++)
	{
		stream.WriteCompressed(game.connectedPeers[t].guid);
		stream.WriteCompressed(game.connectedPeers[t].peerName);
		if (game.connectedPeers[t].player !is null)
		{
			stream.Write(bool(true));
			stream.WriteCompressed(game.connectedPeers[t].player.asset.GetNetworkID());
			stream.Write(game.connectedPeers[t].player.asset.GetPosition().x);
			stream.Write(game.connectedPeers[t].player.asset.GetPosition().y);
			stream.WriteCompressed(game.connectedPeers[t].myTeam.teamName);
		}
		else
			stream.Write(bool(false));
	}
	stream.Send(guid, PP::HIGH_PRIORITY, PR::RELIABLE, 0, false);
	
	game.connectedPeers.insertLast(@newPeer);
	
	bit.SendUA(PP::HIGH_PRIORITY, PR::RELIABLE, 0, true);
}
void PlayerSetup(uint8 MessageID, uint64 guid, BitStream bit)	// This will be only received from a single client, when it first connects.
{
	print("Player setup request!\n");
	Peer@ requesting = game.GetPeerByGUID(guid);
	
	if (requesting is null)
	{
		print("Error - PlayerSetup - No GUID match found.\n");
		return;
	}
		
	vec2 setupPos(rand(2,5), rand(2,5));
	
	string requestedTeam;
	bit.IgnoreBytes(1);
	bit.Read(requestedTeam);
	
	requesting.SetupPlayer(setupPos, game.GetTeamByName(requestedTeam));
	uint64 nid = requesting.player.asset.GetNetworkID();
	
	BitStream stream;
	stream.Write(MessageID);
	stream.WriteCompressed(guid);
	stream.WriteCompressed(nid);
	stream.Write(setupPos.x);
	stream.Write(setupPos.y);
	stream.WriteCompressed(requestedTeam);
	
	stream.SendUA(PP::HIGH_PRIORITY, PR::RELIABLE, 0, true);
}
void PlayerInput(uint8 MessageID, uint64 guid, BitStream bit)	// This will be only received from a single client, when it first connects.
{
	InputData inputData;
	
	bit.IgnoreBytes(1);
	bit.ReadCompressed(inputData.miliseconds);
	bit.Read(inputData.direction.x);
	bit.Read(inputData.direction.y);
	bit.Read(inputData.positionArrived.x);
	bit.Read(inputData.positionArrived.y);
	
	game.GetPeerByGUID(guid).ProcessInputData(inputData);
}
void DisconnectionNotification(uint8 MessageID, uint64 guid, BitStream bit)
{
	if (MessageID == 21)
	print("Disconnecting peer.\n");
	else
	print("Connection lost to peer.\n");
	game.RemovePeerByGUID(guid);
	
	BitStream stream;
	stream.Write(uint8(NetworkMessages::ID_PEER_DISCONNECTED));
	stream.WriteCompressed(guid);
	stream.SendUA(PP::HIGH_PRIORITY, PR::RELIABLE, 0, true);
}
void BulletFired(uint8 MessageID, uint64 guid, BitStream bit)
{
	bit.IgnoreBytes(1);
	uint64 firingGuid;
	float px;
	float py;
	float dx;
	float dy;
	
	bit.Read(firingGuid);
	bit.Read(px);
	bit.Read(py);
	bit.Read(dx);
	bit.Read(dy);
	
	Peer@ firingPeer = game.GetPeerByGUID(guid);
	if (firingPeer is null || firingPeer.player is null)
	return;
	
	Bullet@ bullet = cBullet(CreateAsset("Bullet", vec2(px,py), "Bullet"));
	bullet.Shoot(vec2(dx,dy) - firingPeer.player.asset.GetPosition(), firingPeer.player);
	
	bit.Send(guid, PP::HIGH_PRIORITY, PR::RELIABLE, 3, true);
}