
class Game
{
	array<Peer@> connectedPeers;
	array<Team@> teams;
	Peer@ myPeer;
	
	Timer losTimer;
	
	vec2 cameraMoveTo;
	Timer cameraDelta;
	float cameraSpeed;
	
	Game()
	{
		@myPeer = null;
		
		Team redTeam;
		redTeam.shapeName = "Circle 2";
		redTeam.teamName = "red";
		Team blueTeam;
		blueTeam.shapeName = "Circle 1";
		blueTeam.teamName = "blue";
		Team orangeTeam;
		orangeTeam.shapeName = "Circle 3";
		orangeTeam.teamName = "orange";
		
		teams.insertLast(@redTeam);
		teams.insertLast(@blueTeam);
		teams.insertLast(@orangeTeam);
		cameraSpeed = 6.0f;
	}
	void CameraControls()
	{
		cameraMoveTo = vec2(0,0);
		if (input.IsKeyDown(Code::W))
			cameraMoveTo.y = -1;
		else if(input.IsKeyDown(Code::S))
			cameraMoveTo.y = 1;
		if (input.IsKeyDown(Code::D))
			cameraMoveTo.x = 1;
		else if (input.IsKeyDown(Code::A))
			cameraMoveTo.x = -1;
		if (cameraMoveTo.LengthSq() > 0)
		{
		cameraMoveTo.Normalize();
		cameraMoveTo *= cameraSpeed * cameraDelta.GetElapsedTime() / 1000;
		cameraMoveTo += GetCameraPos();
		SetCameraTransformCentered( cameraMoveTo, 0);
		}
		
		cameraDelta.Reset();
	}
	void LOSCheck()
	{
		AssetQ query;
		for (uint t = 0; t < connectedPeers.length(); t++)
		{
			query.RayCast(myPeer.player.asset.GetPosition(), connectedPeers[t].player.asset.GetPosition());
			query.SetClassFilter("Static");
			uint results = query.RunQuery();
			if (results > 0)
				connectedPeers[t].player.visible = false;
			else
			{
				vec2 distance = myPeer.player.asset.GetPosition() - connectedPeers[t].player.asset.GetPosition();
				if (distance.LengthSq() < 1.4f && connectedPeers[t].player.alpha < 200)
					connectedPeers[t].player.alpha = 200;
				connectedPeers[t].player.visible = true;
			}
		}
	}
	void ShowPlayerInfo()
	{
		string infoText;
		infoText = "Players:\n";
		
		infoText += myPeer.peerName + "\n";
		
		for (uint t = 0; t < connectedPeers.length(); t++)
		{
			infoText += connectedPeers[t].peerName + "\n";
		}
		DrawGUIText(infoText, vec2(0, 120), 18);
	}
	void OnLoop()
	{
		if (input.IsKeyDown(Code::Tab))
			ShowPlayerInfo();
		DrawGUIText("Seek and Tag v0.3", vec2(0, 50), 18);
		if (myPeer.player !is null)
		{
			string healthText = "Health : " + myPeer.player.health;
			DrawGUIText(healthText, vec2(0, 75), 18);
			SetCameraTransform(myPeer.player.asset.GetPosition(), 0);
			
			if (losTimer.GetElapsedTime() > 250)
			{
				LOSCheck();
				losTimer.Reset();
			}
		}
		else
		CameraControls();
		if (!myPeer.setupRequested && input.IsMBDown(MouseButton::Left))
		{
			BitStream stream;
			stream.Write(uint8(NetworkMessages::ID_PLAYER_SETUP));
			stream.Write("red");
			stream.SendUA(PP::HIGH_PRIORITY, PR::RELIABLE, 0, true);
			myPeer.setupRequested = true;
		}
		if (!myPeer.setupRequested && input.IsMBDown(MouseButton::Right))
		{
			BitStream stream;
			stream.Write(uint8(NetworkMessages::ID_PLAYER_SETUP));
			stream.Write("blue");
			stream.SendUA(PP::HIGH_PRIORITY, PR::RELIABLE, 0, true);
			myPeer.setupRequested = true;
		}
		if (!myPeer.setupRequested && input.IsMBDown(MouseButton::Middle))
		{
			BitStream stream;
			stream.Write(uint8(NetworkMessages::ID_PLAYER_SETUP));
			stream.Write("orange");
			stream.SendUA(PP::HIGH_PRIORITY, PR::RELIABLE, 0, true);
			myPeer.setupRequested = true;
		}
		for (uint t = 0; t < connectedPeers.length(); t++)
		{
			connectedPeers[t].OnLoop();
		}
	}
	
	void RemovePeerByGUID( uint64 guid )
	{
		for (uint t = 0; t < connectedPeers.length(); t++)
		{
			if (connectedPeers[t].guid == guid)
			{
				@connectedPeers[t].player.myPeer = null;
				@connectedPeers[t] = null;
				connectedPeers.removeAt(t);
				break;
			}
		}
	}
	
	Peer@ GetPeerByGUID( uint64 guid )
	{
		if ( guid == myPeer.guid)
			return myPeer;
		for (uint t = 0; t < connectedPeers.length(); t++)
		{
			if (connectedPeers[t].guid == guid)
				return connectedPeers[t];
		}
		return null;
	}
	
	Team@ GetTeamByName(string name)
	{
		for (uint t = 0; t < teams.length(); t++)
		{
			if (teams[t].teamName == name)
				return teams[t];
		}
		return null;	
	}
}