#include "keycodes.as"
#include "peer.as"
#include "game.as"
#include "bullet.as"

Game @game = null;
Input input;

Music intro;

enum NetworkMessages
{
	ID_DISCONNECTION_NOTIFICATION = 21,
	ID_CONNECTION_LOST = 22,
	ID_NEW_PEER_JOINED = 150,	// When a new player joins, it sends this to the server
	ID_NEW_PEER_SYNCH,
	ID_PEER_DISCONNECTED,
	ID_PLAYER_SETUP,	// Called when a new player is initialised
	ID_SNAPSHOT,	// Called to update other players - When it is our player, the player is corrected
	ID_PLAYER_INPUT,	// Sent to server
	ID_PLAYER_CORRECTION,
	ID_PLAYER_DIED,		// Marked in this case
	ID_BULLET_FIRED,		// Sent across when a bullet is fired
	ID_ROUND_BEGIN,
	ID_ROUND_END,
	ID_GAME_INFO,	// Round countdown - team scores etc - every 5 seconds
	ID_ROUND_REPORT
}
// Channel 1 : Inputs from clients
// Channel 2 : Corrections

int main()
{
	game.OnLoop();
	return 1;
}

void OnLoad(string arg)
{
	Game g;
	@game = @g;
	
	LoadWorld(arg);
	LoadShapeSet("basic");
	LoadShapeSet("platformer");
	//LoadWorld("deneme");
	
	//if (intro.OpenFromFile("sounds/Ferit Odman - Nommo.ogg"))
	//intro.Play();
	
	AddPacketHandler("NewPeerJoined", NetworkMessages::ID_NEW_PEER_JOINED);
	AddPacketHandler("PlayerSetup", NetworkMessages::ID_PLAYER_SETUP);
	AddPacketHandler("PlayerUpdate", NetworkMessages::ID_SNAPSHOT);
	AddPacketHandler("CorrectionReceive", NetworkMessages::ID_PLAYER_CORRECTION);
	AddPacketHandler("NewPeerSynch", NetworkMessages::ID_NEW_PEER_SYNCH);
	AddPacketHandler("PeerDisconnected", NetworkMessages::ID_PEER_DISCONNECTED);
	AddPacketHandler("BulletFired", NetworkMessages::ID_BULLET_FIRED);
	AddPacketHandler("PlayerDied", NetworkMessages::ID_PLAYER_DIED);
	AddPacketHandler("RoundEnd", NetworkMessages::ID_ROUND_END);
	AddPacketHandler("RoundBegin", NetworkMessages::ID_ROUND_BEGIN);
	AddPacketHandler("GameInfo", NetworkMessages::ID_GAME_INFO);
	
	BitStream stream;
	stream.Write(uint8(NetworkMessages::ID_NEW_PEER_JOINED));
	stream.Write(GetMyGUID());
	stream.WriteCompressed(GetMyName());
	stream.SendUA(PP::HIGH_PRIORITY, PR::RELIABLE, 0, true);
}
void GameInfo(uint8 MessageID, uint64 guid, BitStream bit)	// This will be only received from a single client, when it first connects.
{
	bit.IgnoreBytes(1);
	
	bit.Read(game.mod.state);
	if (game.mod.state == ROUND_IN_PROGRESS)
		bit.ReadCompressed(game.mod.roundTime);
	else
		bit.ReadCompressed(game.mod.waitTime);
	game.mod.countdown.Reset();
}
void NewPeerJoined(uint8 MessageID, uint64 guid, BitStream bit)	// This will be only received from a single client, when it first connects.
{
	bit.IgnoreBytes(1);
	
	uint64 rGUID;
	string name;
	
	Peer newPeer;
	bit.Read(rGUID);
	bit.ReadCompressed(newPeer.peerName);
	newPeer.guid = rGUID;
	
	if (rGUID == GetMyGUID())
	{
		@game.mod.myPeer = @newPeer;
		print("Our peer join request accepted by server!\n");
	}
	else
	{
		game.mod.connectedPeers.insertLast(@newPeer);
		print("New peer joined!\n");
	}
}

void PlayerSetup(uint8 MessageID, uint64 guid, BitStream bit)	// This will be only received from a single client, when it first connects.
{
	print("Player setup received!\n");
	
	uint8 t;
	uint64 rGUID;
	uint64 rNID;
	float rx;
	float ry;
	string requestedTeam;
	
	bit.Read(t);
	bit.ReadCompressed(rGUID);
	
	Peer@ requesting = game.GetPeerByGUID(rGUID);
	if (requesting is null)
	{
		print("Error - PlayerSetup - No GUID match found.\n");
		return;
	}
	
	bit.ReadCompressed(rNID);
	bit.Read(rx);
	bit.Read(ry);
	bit.ReadCompressed(requestedTeam);
	
	vec2 setupPos(rx,ry);
	
	requesting.SetupPlayer(setupPos, false);
	requesting.player.asset.SetNetworkID(rNID);
}
void RoundEnd(uint8 MessageID, uint64 guid, BitStream bit)	// This will be only received from a single client, when it first connects.
{
	uint8 t;
	bit.Read(t);
	bit.ReadCompressed(game.mod.waitTime);
	bit.ReadCompressed(game.report);
	
	game.mod.state = ROUND_COUNTDOWN;
	game.mod.RoundEnd();
	game.mod.countdown.Reset();
}
void RoundBegin(uint8 MessageID, uint64 guid, BitStream bit)	// This will be only received from a single client, when it first connects.
{
	uint8 t;
	bit.Read(t);
	bit.ReadCompressed(game.mod.roundTime);
	
	game.mod.state = ROUND_IN_PROGRESS;
	game.mod.RoundBegin();
	game.mod.countdown.Reset();
}

void NewPeerSynch(uint8 MessageID, uint64 guid, BitStream bit)	// When a new peer connects, it needs to be synched. This function will do all the synching
{
	bit.IgnoreBytes(1);
	
	uint peerCount;
	game.mod.countdown.Reset();
	bit.Read(peerCount);
	for (uint t = 0; t < peerCount; t++)
	{
		Peer newPeer;
		uint64 peerGuid;
		uint64 pNid;
		bool peerHasPlayer;
		float px;
		float py;
		bool marked = false;
		bit.ReadCompressed(peerGuid);
		bit.ReadCompressed(newPeer.peerName);
		bit.Read(peerHasPlayer);
		if (peerHasPlayer)
		{
			bit.ReadCompressed(pNid);
			bit.Read(px);
			bit.Read(py);
			bit.Read(bool(marked));
		}
		
		newPeer.guid = peerGuid;
		if (peerHasPlayer)
		{
		newPeer.SetupPlayer(vec2(px,py), marked);
		newPeer.player.asset.SetNetworkID(pNid);
		}
		game.mod.connectedPeers.insertLast(@newPeer);
	}
}
void PeerDisconnected(uint8 MessageID, uint64 guid, BitStream bit)
{
	uint64 disconnectedGUID;
	bit.IgnoreBytes(1);
	bit.ReadCompressed(disconnectedGUID);
	game.RemovePeerByGUID(disconnectedGUID);
}

void BulletFired(uint8 MessageID, uint64 guid, BitStream bit)
{
	bit.IgnoreBytes(1);
	uint64 firingGuid;
	float px;
	float py;
	float dx;
	float dy;
	
	bit.Read(firingGuid);
	bit.Read(px);
	bit.Read(py);
	bit.Read(dx);
	bit.Read(dy);
	
	Peer@ firingPeer = game.GetPeerByGUID(firingGuid);
	if (firingPeer is null || firingPeer.player is null)
	return;
	
	if (firingPeer.player.marked == false)
			return;
	
	Bullet@ bullet = cBullet(CreateAsset("Bullet", vec2(px,py), "Bullet"));
	bullet.Shoot(vec2(dx,dy) - firingPeer.player.asset.GetPosition(), firingPeer.player);
}
void PlayerDied(uint8 MessageID, uint64 guid, BitStream bit)
{
	uint64 markedGUID;
	uint64 markerGUID;
	
	bit.IgnoreBytes(1);
	bit.ReadCompressed(markedGUID);
	bit.ReadCompressed(markerGUID);
	
	Peer@ markerPeer = game.GetPeerByGUID(markerGUID);
	Peer@ markedPeer = game.GetPeerByGUID(markedGUID);
	
	markedPeer.player.marked = true;
	markerPeer.player.marked = false;
		
	markedPeer.deaths++;
	markerPeer.frags++;
}