Bullet@ cBullet(Asset@ p)	// This function casts an Asset@ to a @Player
{
	Scripted @s = p.GetScripted();
	return cast<Bullet>(s);
}

class Bullet : Scripted, Contact, Actor
{
	Asset@ asset;
	Player@ shotBy;
	
	Timer deletion;
	
	int damage;
	float speed;
	bool active;
	
	Bullet()
	{
		damage = 20;
		speed = 20.0f;
		active = true;
	}
	void Shoot(vec2 direction, Player@ shooter)
	{
		direction.Normalize();
		direction *= speed;
		asset.SetVelocity(direction);
		asset.SetRotation(-atan2(direction.x, direction.y));
		@shotBy = @shooter;
	}
	void SetAsset(Asset@ with)
	{
		@asset = @with;
	}
	void Update()
	{
		if (deletion.GetElapsedTime() > 2000)
		{
			@shotBy = null;
			@asset = null;
		}
	}
	void BeginContact(Asset@ contacted)
	{
	}
	void EndContact(Asset@ contacted)
	{
	}
	bool PreSolve(Asset@ contacted)
	{
		if (shotBy.asset is contacted && active)
			return true;
		else if (contacted.GetClassName() == "Bullet")
		{
			if (shotBy !is cBullet(contacted).shotBy)
			return true;
			else
			return false;
		}
		else if (contacted.GetClassName() == "Player" && active) {
		// Casting from the Asset should be done like this
		@asset = null;	// This deletes the asset.(By deleting the reference)
		return true;
		}
	//@asset = null;	// This deletes the asset.(By deleting the reference)
	active = false;
	return false;
	}
}