/'
this file is part of the "Jumpin' Hi!" project by Saga-Games.
purpose: BASS header
'/

''
''
'' bass -- header translated with help of SWIG FB wrapper
''
'' NOTICE: This file is part of the FreeBASIC Compiler package and can't
''         be included in other distributions without authorization.
''
''
#Ifndef __bass_bi__
#define __bass_bi__

#Inclib "bass"

Type Word As UShort
Type Dword As UInteger
Type BOOL As Integer
Type QWORD As ULongInt
'#define TRUE 1
'#define FALSE 0
#define MAKELONG(a,b) CInt( CUShort(a) Or (CUInt(CUShort(b)) Shl 16) )

#Define BASSVERSION &h204
#Define BASSVERSIONTEXT "2.4"

Type HMUSIC As Dword
Type HSAMPLE As Dword
Type HCHANNEL As Dword
Type HSTREAM As Dword
Type HRECORD As Dword
Type HSYNC As Dword
Type HDSP As Dword
Type HFX As Dword
Type HPLUGIN As Dword

#define BASS_OK 0
#define BASS_ERROR_MEM 1
#define BASS_ERROR_FILEOPEN 2
#define BASS_ERROR_DRIVER 3
#define BASS_ERROR_BUFLOST 4
#define BASS_ERROR_HANDLE 5
#define BASS_ERROR_FORMAT 6
#define BASS_ERROR_POSITION 7
#define BASS_ERROR_INIT 8
#define BASS_ERROR_START 9
#define BASS_ERROR_ALREADY 14
#define BASS_ERROR_NOCHAN 18
#define BASS_ERROR_ILLTYPE 19
#define BASS_ERROR_ILLPARAM 20
#define BASS_ERROR_NO3D 21
#define BASS_ERROR_NOEAX 22
#define BASS_ERROR_DEVICE 23
#define BASS_ERROR_NOPLAY 24
#define BASS_ERROR_FREQ 25
#define BASS_ERROR_NOTFILE 27
#define BASS_ERROR_NOHW 29
#define BASS_ERROR_EMPTY 31
#define BASS_ERROR_NONET 32
#define BASS_ERROR_CREATE 33
#define BASS_ERROR_NOFX 34
#define BASS_ERROR_NOTAVAIL 37
#define BASS_ERROR_DECODE 38
#define BASS_ERROR_DX 39
#define BASS_ERROR_TIMEOUT 40
#define BASS_ERROR_FILEFORM 41
#define BASS_ERROR_SPEAKER 42
#define BASS_ERROR_VERSION 43
#define BASS_ERROR_CODEC 44
#define BASS_ERROR_ENDED 45
#define BASS_ERROR_UNKNOWN -1
#define BASS_CONFIG_BUFFER 0
#define BASS_CONFIG_UPDATEPERIOD 1
#define BASS_CONFIG_GVOL_SAMPLE 4
#define BASS_CONFIG_GVOL_STREAM 5
#define BASS_CONFIG_GVOL_MUSIC 6
#define BASS_CONFIG_CURVE_VOL 7
#define BASS_CONFIG_CURVE_PAN 8
#define BASS_CONFIG_FLOATDSP 9
#define BASS_CONFIG_3DALGORITHM 10
#define BASS_CONFIG_NET_TIMEOUT 11
#define BASS_CONFIG_NET_BUFFER 12
#define BASS_CONFIG_PAUSE_NOPLAY 13
#define BASS_CONFIG_NET_PREBUF 15
#define BASS_CONFIG_NET_PASSIVE 18
#define BASS_CONFIG_REC_BUFFER 19
#define BASS_CONFIG_NET_PLAYLIST 21
#define BASS_CONFIG_MUSIC_VIRTUAL 22
#define BASS_CONFIG_VERIFY 23
#define BASS_CONFIG_UPDATETHREADS 24
#define BASS_CONFIG_NET_AGENT 16
#define BASS_CONFIG_NET_PROXY 17
#define BASS_DEVICE_8BITS 1
#define BASS_DEVICE_MONO 2
#define BASS_DEVICE_3D 4
#define BASS_DEVICE_LATENCY 256
#define BASS_DEVICE_CPSPEAKERS 1024
#define BASS_DEVICE_SPEAKERS 2048
#define BASS_DEVICE_NOSPEAKER 4096
#define BASS_OBJECT_DS 1
#define BASS_OBJECT_DS3DL 2

Type BASS_DEVICEINFO
	Name As ZString Ptr
	driver As ZString Ptr
	flags As DWORD
End Type

#define BASS_DEVICE_ENABLED 1
#define BASS_DEVICE_DEFAULT 2
#define BASS_DEVICE_INIT 4

Type BASS_INFO
	flags As DWORD
	hwsize As DWORD
	hwfree As DWORD
	freesam As DWORD
	free3d As DWORD
	minrate As DWORD
	maxrate As DWORD
	eax As BOOL
	minbuf As DWORD
	dsver As DWORD
	latency As DWORD
	initflags As DWORD
	speakers As DWORD
	freq As DWORD
End Type

#define DSCAPS_CONTINUOUSRATE &h00000010
#define DSCAPS_EMULDRIVER &h00000020
#define DSCAPS_CERTIFIED &h00000040
#define DSCAPS_SECONDARYMONO &h00000100
#define DSCAPS_SECONDARYSTEREO &h00000200
#define DSCAPS_SECONDARY8BIT &h00000400
#define DSCAPS_SECONDARY16BIT &h00000800

Type BASS_RECORDINFO
	flags As DWORD
	formats As DWORD
	inputs As DWORD
	singlein As BOOL
	freq As DWORD
End Type

#define DSCCAPS_EMULDRIVER &h00000020
#define DSCCAPS_CERTIFIED &h00000040
#define WAVE_FORMAT_1M08 &h00000001
#define WAVE_FORMAT_1S08 &h00000002
#define WAVE_FORMAT_1M16 &h00000004
#define WAVE_FORMAT_1S16 &h00000008
#define WAVE_FORMAT_2M08 &h00000010
#define WAVE_FORMAT_2S08 &h00000020
#define WAVE_FORMAT_2M16 &h00000040
#define WAVE_FORMAT_2S16 &h00000080
#define WAVE_FORMAT_4M08 &h00000100
#define WAVE_FORMAT_4S08 &h00000200
#define WAVE_FORMAT_4M16 &h00000400
#define WAVE_FORMAT_4S16 &h00000800

Type BASS_SAMPLE
	freq As DWORD
	volume As Single
	pan As Single
	flags As DWORD
	length As DWORD
	max As DWORD
	origres As DWORD
	chans As DWORD
	mingap As DWORD
	mode3d As DWORD
	mindist As Single
	maxdist As Single
	iangle As DWORD
	oangle As DWORD
	outvol As Single
	vam As DWORD
	priority As DWORD
End Type

#define BASS_SAMPLE_8BITS 1
#define BASS_SAMPLE_FLOAT 256
#define BASS_SAMPLE_MONO 2
#define BASS_SAMPLE_LOOP 4
#define BASS_SAMPLE_3D 8
#define BASS_SAMPLE_SOFTWARE 16
#define BASS_SAMPLE_MUTEMAX 32
#define BASS_SAMPLE_VAM 64
#define BASS_SAMPLE_FX 128
#define BASS_SAMPLE_OVER_VOL &h10000
#define BASS_SAMPLE_OVER_POS &h20000
#define BASS_SAMPLE_OVER_DIST &h30000
#define BASS_STREAM_PRESCAN &h20000
#define BASS_MP3_SETPOS &h20000
#define BASS_STREAM_AUTOFREE &h40000
#define BASS_STREAM_RESTRATE &h80000
#define BASS_STREAM_BLOCK &h100000
#define BASS_STREAM_DECODE &h200000
#define BASS_STREAM_STATUS &h800000
#define BASS_MUSIC_FLOAT 256
#define BASS_MUSIC_MONO 2
#define BASS_MUSIC_LOOP 4
#define BASS_MUSIC_3D 8
#define BASS_MUSIC_FX 128
#define BASS_MUSIC_AUTOFREE &h40000
#define BASS_MUSIC_DECODE &h200000
#define BASS_MUSIC_PRESCAN &h20000
#define BASS_MUSIC_CALCLEN &h20000
#define BASS_MUSIC_RAMP &h200
#define BASS_MUSIC_RAMPS &h400
#define BASS_MUSIC_SURROUND &h800
#define BASS_MUSIC_SURROUND2 &h1000
#define BASS_MUSIC_FT2MOD &h2000
#define BASS_MUSIC_PT1MOD &h4000
#define BASS_MUSIC_NONINTER &h10000
#define BASS_MUSIC_SINCINTER &h800000
#define BASS_MUSIC_POSRESET &h8000
#define BASS_MUSIC_POSRESETEX &h400000
#define BASS_MUSIC_STOPBACK &h80000
#define BASS_MUSIC_NOSAMPLE &h100000
#define BASS_SPEAKER_FRONT &h1000000
#define BASS_SPEAKER_REAR &h2000000
#define BASS_SPEAKER_CENLFE &h3000000
#define BASS_SPEAKER_REAR2 &h4000000
#define BASS_SPEAKER_LEFT &h10000000
#define BASS_SPEAKER_RIGHT &h20000000
#define BASS_SPEAKER_FRONTLEFT &h1000000 Or &h10000000
#define BASS_SPEAKER_FRONTRIGHT &h1000000 Or &h20000000
#define BASS_SPEAKER_REARLEFT &h2000000 Or &h10000000
#define BASS_SPEAKER_REARRIGHT &h2000000 Or &h20000000
#define BASS_SPEAKER_CENTER &h3000000 Or &h10000000
#define BASS_SPEAKER_LFE &h3000000 Or &h20000000
#define BASS_SPEAKER_REAR2LEFT &h4000000 Or &h10000000
#define BASS_SPEAKER_REAR2RIGHT &h4000000 Or &h20000000
#define BASS_UNICODE &h80000000
#define BASS_RECORD_PAUSE &h8000
#define BASS_VAM_HARDWARE 1
#define BASS_VAM_SOFTWARE 2
#define BASS_VAM_TERM_TIME 4
#define BASS_VAM_TERM_DIST 8
#define BASS_VAM_TERM_PRIO 16

Type BASS_CHANNELINFO
	freq As DWORD
	chans As DWORD
	flags As DWORD
	ctype As DWORD
	origres As DWORD
	plugin As HPLUGIN
	sample As HSAMPLE
	filename As ZString Ptr
End Type

#define BASS_CTYPE_SAMPLE 1
#define BASS_CTYPE_RECORD 2
#define BASS_CTYPE_STREAM &h10000
#define BASS_CTYPE_STREAM_OGG &h10002
#define BASS_CTYPE_STREAM_MP1 &h10003
#define BASS_CTYPE_STREAM_MP2 &h10004
#define BASS_CTYPE_STREAM_MP3 &h10005
#define BASS_CTYPE_STREAM_AIFF &h10006
#define BASS_CTYPE_STREAM_WAV &h40000
#define BASS_CTYPE_STREAM_WAV_PCM &h50001
#define BASS_CTYPE_STREAM_WAV_FLOAT &h50003
#define BASS_CTYPE_MUSIC_MOD &h20000
#define BASS_CTYPE_MUSIC_MTM &h20001
#define BASS_CTYPE_MUSIC_S3M &h20002
#define BASS_CTYPE_MUSIC_XM &h20003
#define BASS_CTYPE_MUSIC_IT &h20004
#define BASS_CTYPE_MUSIC_MO3 &h00100

Type BASS_PLUGINFORM
	ctype As DWORD
	Name As ZString Ptr
	exts As ZString Ptr
End Type

Type BASS_PLUGININFO
	version As DWORD
	formatc As DWORD
	formats As BASS_PLUGINFORM Ptr
End Type

Type BASS_3DVECTOR
	x As Single
	y As Single
	z As Single
End Type

#define BASS_3DMODE_NORMAL 0
#define BASS_3DMODE_RELATIVE 1
#define BASS_3DMODE_OFF 2
#define BASS_3DALG_DEFAULT 0
#define BASS_3DALG_OFF 1
#define BASS_3DALG_FULL 2
#define BASS_3DALG_LIGHT 3

Type STREAMPROC As DWORD

#define BASS_STREAMPROC_END &h80000000
#define STREAMFILE_NOBUFFER 0
#define STREAMFILE_BUFFER 1
#define STREAMFILE_BUFFERPUSH 2

Type FILECLOSEPROC As Any
Type FILELENPROC As QWORD
Type FILEREADPROC As DWORD
Type FILESEEKPROC As BOOL

Type BASS_FILEPROCS
	Close As FILECLOSEPROC Ptr
	length As FILELENPROC Ptr
	Read As FILEREADPROC Ptr
	Seek As FILESEEKPROC Ptr
End Type

#define BASS_FILEDATA_END 0
#define BASS_FILEPOS_CURRENT 0
#define BASS_FILEPOS_DECODE 0
#define BASS_FILEPOS_DOWNLOAD 1
#define BASS_FILEPOS_END 2
#define BASS_FILEPOS_START 3
#define BASS_FILEPOS_CONNECTED 4
#define BASS_FILEPOS_BUFFER 5
#define BASS_FILEPOS_SOCKET 6

Type DOWNLOADPROC As Any

#define BASS_SYNC_POS 0
#define BASS_SYNC_END 2
#define BASS_SYNC_META 4
#define BASS_SYNC_SLIDE 5
#define BASS_SYNC_STALL 6
#define BASS_SYNC_DOWNLOAD 7
#define BASS_SYNC_FREE 8
#define BASS_SYNC_SETPOS 11
#define BASS_SYNC_MUSICPOS 10
#define BASS_SYNC_MUSICINST 1
#define BASS_SYNC_MUSICFX 3
#define BASS_SYNC_OGG_CHANGE 12
#define BASS_SYNC_MIXTIME &h40000000
#define BASS_SYNC_ONETIME &h80000000

Type SYNCPROC As Any
Type DSPPROC As Any
Type RECORDPROC As BOOL

#define BASS_ACTIVE_STOPPED 0
#define BASS_ACTIVE_PLAYING 1
#define BASS_ACTIVE_STALLED 2
#define BASS_ACTIVE_PAUSED 3
#define BASS_ATTRIB_FREQ 1
#define BASS_ATTRIB_VOL 2
#define BASS_ATTRIB_PAN 3
#define BASS_ATTRIB_EAXMIX 4
#define BASS_ATTRIB_MUSIC_AMPLIFY &h100
#define BASS_ATTRIB_MUSIC_PANSEP &h101
#define BASS_ATTRIB_MUSIC_PSCALER &h102
#define BASS_ATTRIB_MUSIC_BPM &h103
#define BASS_ATTRIB_MUSIC_SPEED &h104
#define BASS_ATTRIB_MUSIC_VOL_GLOBAL &h105
#define BASS_ATTRIB_MUSIC_VOL_CHAN &h200
#define BASS_ATTRIB_MUSIC_VOL_INST &h300
#define BASS_DATA_AVAILABLE 0
#define BASS_DATA_FLOAT &h40000000
#define BASS_DATA_FFT256 &h80000000
#define BASS_DATA_FFT512 &h80000001
#define BASS_DATA_FFT1024 &h80000002
#define BASS_DATA_FFT2048 &h80000003
#define BASS_DATA_FFT4096 &h80000004
#define BASS_DATA_FFT8192 &h80000005
#define BASS_DATA_FFT_INDIVIDUAL &h10
#define BASS_DATA_FFT_NOWINDOW &h20
#define BASS_TAG_ID3 0
#define BASS_TAG_ID3V2 1
#define BASS_TAG_OGG 2
#define BASS_TAG_HTTP 3
#define BASS_TAG_ICY 4
#define BASS_TAG_META 5
#define BASS_TAG_VENDOR 9
#define BASS_TAG_LYRICS3 10
#define BASS_TAG_RIFF_INFO &h100
#define BASS_TAG_RIFF_BEXT &h101
#define BASS_TAG_MUSIC_NAME &h10000
#define BASS_TAG_MUSIC_MESSAGE &h10001
#define BASS_TAG_MUSIC_ORDERS &h10002
#define BASS_TAG_MUSIC_INST &h10100
#define BASS_TAG_MUSIC_SAMPLE &h10300

Type TAG_ID3
	id As ZString * 3
	title As ZString * 30
	artist As ZString * 30
	album As ZString * 30
	Year As ZString * 4
	comment As ZString * 30
	genre As Byte
End Type

#define BASS_POS_BYTE 0
#define BASS_POS_MUSIC_ORDER 1
#define BASS_INPUT_OFF &h10000
#define BASS_INPUT_ON &h20000
#define BASS_INPUT_TYPE_MASK &hff000000
#define BASS_INPUT_TYPE_UNDEF &h00000000
#define BASS_INPUT_TYPE_DIGITAL &h01000000
#define BASS_INPUT_TYPE_LINE &h02000000
#define BASS_INPUT_TYPE_MIC &h03000000
#define BASS_INPUT_TYPE_SYNTH &h04000000
#define BASS_INPUT_TYPE_CD &h05000000
#define BASS_INPUT_TYPE_PHONE &h06000000
#define BASS_INPUT_TYPE_SPEAKER &h07000000
#define BASS_INPUT_TYPE_WAVE &h08000000
#define BASS_INPUT_TYPE_AUX &h09000000
#define BASS_INPUT_TYPE_ANALOG &h0a000000

Enum 
	BASS_FX_DX8_CHORUS
	BASS_FX_DX8_COMPRESSOR
	BASS_FX_DX8_DISTORTION
	BASS_FX_DX8_ECHO
	BASS_FX_DX8_FLANGER
	BASS_FX_DX8_GARGLE
	BASS_FX_DX8_I3DL2REVERB
	BASS_FX_DX8_PARAMEQ
	BASS_FX_DX8_REVERB
End Enum

Type BASS_DX8_CHORUS
	fWetDryMix As Single
	fDepth As Single
	fFeedback As Single
	fFrequency As Single
	lWaveform As DWORD
	fDelay As Single
	lPhase As DWORD
End Type

Type BASS_DX8_COMPRESSOR
	fGain As Single
	fAttack As Single
	fRelease As Single
	fThreshold As Single
	fRatio As Single
	fPredelay As Single
End Type

Type BASS_DX8_DISTORTION
	fGain As Single
	fEdge As Single
	fPostEQCenterFrequency As Single
	fPostEQBandwidth As Single
	fPreLowpassCutoff As Single
End Type

Type BASS_DX8_ECHO
	fWetDryMix As Single
	fFeedback As Single
	fLeftDelay As Single
	fRightDelay As Single
	lPanDelay As BOOL
End Type

Type BASS_DX8_FLANGER
	fWetDryMix As Single
	fDepth As Single
	fFeedback As Single
	fFrequency As Single
	lWaveform As DWORD
	fDelay As Single
	lPhase As DWORD
End Type

Type BASS_DX8_GARGLE
	dwRateHz As DWORD
	dwWaveShape As DWORD
End Type

Type BASS_DX8_I3DL2REVERB
	lRoom As Integer
	lRoomHF As Integer
	flRoomRolloffFactor As Single
	flDecayTime As Single
	flDecayHFRatio As Single
	lReflections As Integer
	flReflectionsDelay As Single
	lReverb As Integer
	flReverbDelay As Single
	flDiffusion As Single
	flDensity As Single
	flHFReference As Single
End Type

Type BASS_DX8_PARAMEQ
	fCenter As Single
	fBandwidth As Single
	fGain As Single
End Type

Type BASS_DX8_REVERB
	fInGain As Single
	fReverbMix As Single
	fReverbTime As Single
	fHighFreqRTRatio As Single
End Type

#define BASS_DX8_PHASE_NEG_180 0
#define BASS_DX8_PHASE_NEG_90 1
#define BASS_DX8_PHASE_ZERO 2
#define BASS_DX8_PHASE_90 3
#define BASS_DX8_PHASE_180 4

Declare Function BASS_SetConfig Alias "BASS_SetConfig" (ByVal option As DWORD, ByVal value As DWORD) As BOOL
Declare Function BASS_GetConfig Alias "BASS_GetConfig" (ByVal option As DWORD) As DWORD
Declare Function BASS_SetConfigPtr Alias "BASS_SetConfigPtr" (ByVal option As DWORD, ByVal value As Any Ptr) As BOOL
Declare Function BASS_GetConfigPtr Alias "BASS_GetConfigPtr" (ByVal option As DWORD) As Any Ptr
Declare Function BASS_GetVersion Alias "BASS_GetVersion" () As DWORD
Declare Function BASS_ErrorGetCode Alias "BASS_ErrorGetCode" () As Integer
Declare Function BASS_GetDeviceInfo Alias "BASS_GetDeviceInfo" (ByVal device As DWORD, ByVal info As BASS_DEVICEINFO Ptr) As BOOL
Declare Function BASS_Init Alias "BASS_Init" (ByVal device As Integer, ByVal freq As DWORD, ByVal flags As DWORD, ByVal win As Any Ptr, ByVal dsguid As Any Ptr) As BOOL
Declare Function BASS_SetDevice Alias "BASS_SetDevice" (ByVal device As DWORD) As BOOL
Declare Function BASS_GetDevice Alias "BASS_GetDevice" () As DWORD
Declare Function BASS_Free Alias "BASS_Free" () As BOOL
Declare Function BASS_GetInfo Alias "BASS_GetInfo" (ByVal info As BASS_INFO Ptr) As BOOL
Declare Function BASS_Update Alias "BASS_Update" (ByVal length As DWORD) As BOOL
Declare Function BASS_GetCPU Alias "BASS_GetCPU" () As Single
Declare Function BASS_Start Alias "BASS_Start" () As BOOL
Declare Function BASS_Stop Alias "BASS_Stop" () As BOOL
Declare Function BASS_Pause Alias "BASS_Pause" () As BOOL
Declare Function BASS_SetVolume Alias "BASS_SetVolume" (ByVal volume As Single) As BOOL
Declare Function BASS_GetVolume Alias "BASS_GetVolume" () As Single
Declare Function BASS_PluginLoad Alias "BASS_PluginLoad" (ByVal file As ZString Ptr, ByVal flags As DWORD) As HPLUGIN
Declare Function BASS_PluginFree Alias "BASS_PluginFree" (ByVal handle As HPLUGIN) As BOOL
Declare Function BASS_PluginGetInfo Alias "BASS_PluginGetInfo" (ByVal handle As HPLUGIN) As BASS_PLUGININFO Ptr
Declare Function BASS_Set3DFactors Alias "BASS_Set3DFactors" (ByVal distf As Single, ByVal rollf As Single, ByVal doppf As Single) As BOOL
Declare Function BASS_Get3DFactors Alias "BASS_Get3DFactors" (ByVal distf As Single Ptr, ByVal rollf As Single Ptr, ByVal doppf As Single Ptr) As BOOL
Declare Function BASS_Set3DPosition Alias "BASS_Set3DPosition" (ByVal Pos As BASS_3DVECTOR Ptr, ByVal vel As BASS_3DVECTOR Ptr, ByVal front As BASS_3DVECTOR Ptr, ByVal top As BASS_3DVECTOR Ptr) As BOOL
Declare Function BASS_Get3DPosition Alias "BASS_Get3DPosition" (ByVal Pos As BASS_3DVECTOR Ptr, ByVal vel As BASS_3DVECTOR Ptr, ByVal front As BASS_3DVECTOR Ptr, ByVal top As BASS_3DVECTOR Ptr) As BOOL
Declare Sub BASS_Apply3D Alias "BASS_Apply3D" ()
Declare Function BASS_MusicLoad Alias "BASS_MusicLoad" (ByVal mem As BOOL, ByVal file As Any Ptr, ByVal offset As QWORD, ByVal length As DWORD, ByVal flags As DWORD, ByVal freq As DWORD) As HMUSIC
Declare Function BASS_MusicFree Alias "BASS_MusicFree" (ByVal handle As HMUSIC) As BOOL
Declare Function BASS_SampleLoad Alias "BASS_SampleLoad" (ByVal mem As BOOL, ByVal file As Any Ptr, ByVal offset As QWORD, ByVal length As DWORD, ByVal max As DWORD, ByVal flags As DWORD) As HSAMPLE
Declare Function BASS_SampleCreate Alias "BASS_SampleCreate" (ByVal length As DWORD, ByVal freq As DWORD, ByVal chans As DWORD, ByVal max As DWORD, ByVal flags As DWORD) As HSAMPLE
Declare Function BASS_SampleFree Alias "BASS_SampleFree" (ByVal handle As HSAMPLE) As BOOL
Declare Function BASS_SampleSetData Alias "BASS_SampleSetData" (ByVal handle As HSAMPLE, ByVal buffer As Any Ptr) As BOOL
Declare Function BASS_SampleGetData Alias "BASS_SampleGetData" (ByVal handle As HSAMPLE, ByVal buffer As Any Ptr) As BOOL
Declare Function BASS_SampleGetInfo Alias "BASS_SampleGetInfo" (ByVal handle As HSAMPLE, ByVal info As BASS_SAMPLE Ptr) As BOOL
Declare Function BASS_SampleSetInfo Alias "BASS_SampleSetInfo" (ByVal handle As HSAMPLE, ByVal info As BASS_SAMPLE Ptr) As BOOL
Declare Function BASS_SampleGetChannel Alias "BASS_SampleGetChannel" (ByVal handle As HSAMPLE, ByVal onlynew As BOOL) As HCHANNEL
Declare Function BASS_SampleGetChannels Alias "BASS_SampleGetChannels" (ByVal handle As HSAMPLE, ByVal channels As HCHANNEL Ptr) As DWORD
Declare Function BASS_SampleStop Alias "BASS_SampleStop" (ByVal handle As HSAMPLE) As BOOL
Declare Function BASS_StreamCreate Alias "BASS_StreamCreate" (ByVal freq As DWORD, ByVal chans As DWORD, ByVal flags As DWORD, ByVal proc As STREAMPROC Ptr, ByVal user As Any Ptr) As HSTREAM
Declare Function BASS_StreamCreateFile Alias "BASS_StreamCreateFile" (ByVal mem As BOOL, ByVal file As Any Ptr, ByVal offset As QWORD, ByVal length As QWORD, ByVal flags As DWORD) As HSTREAM
Declare Function BASS_StreamCreateURL Alias "BASS_StreamCreateURL" (ByVal url As ZString Ptr, ByVal offset As DWORD, ByVal flags As DWORD, ByVal proc As DOWNLOADPROC Ptr, ByVal user As Any Ptr) As HSTREAM
Declare Function BASS_StreamCreateFileUser Alias "BASS_StreamCreateFileUser" (ByVal System As DWORD, ByVal flags As DWORD, ByVal proc As BASS_FILEPROCS Ptr, ByVal user As Any Ptr) As HSTREAM
Declare Function BASS_StreamFree Alias "BASS_StreamFree" (ByVal handle As HSTREAM) As BOOL
Declare Function BASS_StreamGetFilePosition Alias "BASS_StreamGetFilePosition" (ByVal handle As HSTREAM, ByVal mode As DWORD) As QWORD
Declare Function BASS_StreamPutData Alias "BASS_StreamPutData" (ByVal handle As HSTREAM, ByVal buffer As Any Ptr, ByVal length As DWORD) As DWORD
Declare Function BASS_StreamPutFileData Alias "BASS_StreamPutFileData" (ByVal handle As HSTREAM, ByVal buffer As Any Ptr, ByVal length As DWORD) As DWORD
Declare Function BASS_RecordGetDeviceInfo Alias "BASS_RecordGetDeviceInfo" (ByVal device As DWORD, ByVal info As BASS_DEVICEINFO Ptr) As BOOL
Declare Function BASS_RecordInit Alias "BASS_RecordInit" (ByVal device As Integer) As BOOL
Declare Function BASS_RecordSetDevice Alias "BASS_RecordSetDevice" (ByVal device As DWORD) As BOOL
Declare Function BASS_RecordGetDevice Alias "BASS_RecordGetDevice" () As DWORD
Declare Function BASS_RecordFree Alias "BASS_RecordFree" () As BOOL
Declare Function BASS_RecordGetInfo Alias "BASS_RecordGetInfo" (ByVal info As BASS_RECORDINFO Ptr) As BOOL
Declare Function BASS_RecordGetInputName Alias "BASS_RecordGetInputName" (ByVal Input As Integer) As ZString Ptr
Declare Function BASS_RecordSetInput Alias "BASS_RecordSetInput" (ByVal Input As Integer, ByVal flags As DWORD, ByVal volume As Single) As BOOL
Declare Function BASS_RecordGetInput Alias "BASS_RecordGetInput" (ByVal Input As Integer, ByVal volume As Single Ptr) As DWORD
Declare Function BASS_RecordStart Alias "BASS_RecordStart" (ByVal freq As DWORD, ByVal chans As DWORD, ByVal flags As DWORD, ByVal proc As RECORDPROC Ptr, ByVal user As Any Ptr) As HRECORD
Declare Function BASS_ChannelBytes2Seconds Alias "BASS_ChannelBytes2Seconds" (ByVal handle As DWORD, ByVal Pos As QWORD) As Double
Declare Function BASS_ChannelSeconds2Bytes Alias "BASS_ChannelSeconds2Bytes" (ByVal handle As DWORD, ByVal Pos As Double) As QWORD
Declare Function BASS_ChannelGetDevice Alias "BASS_ChannelGetDevice" (ByVal handle As DWORD) As DWORD
Declare Function BASS_ChannelSetDevice Alias "BASS_ChannelSetDevice" (ByVal handle As DWORD, ByVal device As DWORD) As BOOL
Declare Function BASS_ChannelIsActive Alias "BASS_ChannelIsActive" (ByVal handle As DWORD) As DWORD
Declare Function BASS_ChannelGetInfo Alias "BASS_ChannelGetInfo" (ByVal handle As DWORD, ByVal info As BASS_CHANNELINFO Ptr) As BOOL
Declare Function BASS_ChannelGetTags Alias "BASS_ChannelGetTags" (ByVal handle As DWORD, ByVal tags As DWORD) As ZString Ptr
Declare Function BASS_ChannelFlags Alias "BASS_ChannelFlags" (ByVal handle As DWORD, ByVal flags As DWORD, ByVal mask As DWORD) As DWORD
Declare Function BASS_ChannelUpdate Alias "BASS_ChannelUpdate" (ByVal handle As DWORD, ByVal length As DWORD) As BOOL
Declare Function BASS_ChannelLock Alias "BASS_ChannelLock" (ByVal handle As DWORD, ByVal Lock As BOOL) As BOOL
Declare Function BASS_ChannelPlay Alias "BASS_ChannelPlay" (ByVal handle As DWORD, ByVal restart As BOOL) As BOOL
Declare Function BASS_ChannelStop Alias "BASS_ChannelStop" (ByVal handle As DWORD) As BOOL
Declare Function BASS_ChannelPause Alias "BASS_ChannelPause" (ByVal handle As DWORD) As BOOL
Declare Function BASS_ChannelSetAttribute Alias "BASS_ChannelSetAttribute" (ByVal handle As DWORD, ByVal attrib As DWORD, ByVal value As Single) As BOOL
Declare Function BASS_ChannelGetAttribute Alias "BASS_ChannelGetAttribute" (ByVal handle As DWORD, ByVal attrib As DWORD, ByVal value As Single Ptr) As BOOL
Declare Function BASS_ChannelSlideAttribute Alias "BASS_ChannelSlideAttribute" (ByVal handle As DWORD, ByVal attrib As DWORD, ByVal value As Single, ByVal Time As DWORD) As BOOL
Declare Function BASS_ChannelIsSliding Alias "BASS_ChannelIsSliding" (ByVal handle As DWORD, ByVal attrib As DWORD) As BOOL
Declare Function BASS_ChannelSet3DAttributes Alias "BASS_ChannelSet3DAttributes" (ByVal handle As DWORD, ByVal mode As Integer, ByVal min As Single, ByVal max As Single, ByVal iangle As Integer, ByVal oangle As Integer, ByVal outvol As Single) As BOOL
Declare Function BASS_ChannelGet3DAttributes Alias "BASS_ChannelGet3DAttributes" (ByVal handle As DWORD, ByVal mode As DWORD Ptr, ByVal min As Single Ptr, ByVal max As Single Ptr, ByVal iangle As DWORD Ptr, ByVal oangle As DWORD Ptr, ByVal outvol As Single Ptr) As BOOL
Declare Function BASS_ChannelSet3DPosition Alias "BASS_ChannelSet3DPosition" (ByVal handle As DWORD, ByVal Pos As BASS_3DVECTOR Ptr, ByVal orient As BASS_3DVECTOR Ptr, ByVal vel As BASS_3DVECTOR Ptr) As BOOL
Declare Function BASS_ChannelGet3DPosition Alias "BASS_ChannelGet3DPosition" (ByVal handle As DWORD, ByVal Pos As BASS_3DVECTOR Ptr, ByVal orient As BASS_3DVECTOR Ptr, ByVal vel As BASS_3DVECTOR Ptr) As BOOL
Declare Function BASS_ChannelGetLength Alias "BASS_ChannelGetLength" (ByVal handle As DWORD, ByVal mode As DWORD) As QWORD
Declare Function BASS_ChannelSetPosition Alias "BASS_ChannelSetPosition" (ByVal handle As DWORD, ByVal Pos As QWORD, ByVal mode As DWORD) As BOOL
Declare Function BASS_ChannelGetPosition Alias "BASS_ChannelGetPosition" (ByVal handle As DWORD, ByVal mode As DWORD) As QWORD
Declare Function BASS_ChannelGetLevel Alias "BASS_ChannelGetLevel" (ByVal handle As DWORD) As DWORD
Declare Function BASS_ChannelGetData Alias "BASS_ChannelGetData" (ByVal handle As DWORD, ByVal buffer As Any Ptr, ByVal length As DWORD) As DWORD
Declare Function BASS_ChannelSetSync Alias "BASS_ChannelSetSync" (ByVal handle As DWORD, ByVal Type As DWORD, ByVal param As QWORD, ByVal proc As SYNCPROC Ptr, ByVal user As Any Ptr) As HSYNC
Declare Function BASS_ChannelRemoveSync Alias "BASS_ChannelRemoveSync" (ByVal handle As DWORD, ByVal sync As HSYNC) As BOOL
Declare Function BASS_ChannelSetDSP Alias "BASS_ChannelSetDSP" (ByVal handle As DWORD, ByVal proc As DSPPROC Ptr, ByVal user As Any Ptr, ByVal priority As Integer) As HDSP
Declare Function BASS_ChannelRemoveDSP Alias "BASS_ChannelRemoveDSP" (ByVal handle As DWORD, ByVal dsp As HDSP) As BOOL
Declare Function BASS_ChannelSetLink Alias "BASS_ChannelSetLink" (ByVal handle As DWORD, ByVal chan As DWORD) As BOOL
Declare Function BASS_ChannelRemoveLink Alias "BASS_ChannelRemoveLink" (ByVal handle As DWORD, ByVal chan As DWORD) As BOOL
Declare Function BASS_ChannelSetFX Alias "BASS_ChannelSetFX" (ByVal handle As DWORD, ByVal Type As DWORD, ByVal priority As Integer) As HFX
Declare Function BASS_ChannelRemoveFX Alias "BASS_ChannelRemoveFX" (ByVal handle As DWORD, ByVal fx As HFX) As BOOL
Declare Function BASS_FXSetParameters Alias "BASS_FXSetParameters" (ByVal handle As HFX, ByVal params As Any Ptr) As BOOL
Declare Function BASS_FXGetParameters Alias "BASS_FXGetParameters" (ByVal handle As HFX, ByVal params As Any Ptr) As BOOL
Declare Function BASS_FXReset Alias "BASS_FXReset" (ByVal handle As HFX) As BOOL

#EndIf
