
require('tiedemies')
local noi_number
local texdata
local tex_ppm, tex_width, tex_height
local mover = 0

local transx = {}

-- this is done only once, when the demo starts
function pic128_load() 
	ppm_num = memarray('uchar', 1)
	glGenTextures(1, ppm_num:ptr())
	noi_number = ppm_num[0]
	texdata = memarray('uchar', 64*64)
end

-- done just before first _paint
function pic128_init(millis)
	--print("pic128_init "..millis)
	effu_start = millis
	mover = 0
	for i = 0, 128 do
		transx[i] = 0
	end
end

-- millis = milliseconds in song
function pic128_paint(millis, timedelta, params)
	for y = 0, 32 do
		for x = 0, 63 do
			texdata[y*64+x] = ((math.cos(x-1*0.1)*math.sin(y-1*0.1)*millis*0.001)*255)
		end
	end
	for y = 32, 63 do
		for x = 0, 63 do
			texdata[y*64+x] = 0
		end
	end

	glBindTexture(GL_TEXTURE_2D, noi_number)
        glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST)
        glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST)
        glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT)
        glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT)
        glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_ENV_MODE, GL_MODULATE)
        glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE)
        glTexImage2D(GL_TEXTURE_2D, 0, 3, 64, 64, 0, GL_LUMINANCE, GL_UNSIGNED_BYTE, texdata:ptr())

	spectrum = engine_spectrum()

	beat = 0
	local beatcount = 50
	for i = 100, 100+beatcount do
		beat = beat + spectrum[i]
	end

	beat = beat / beatcount

	glClearColor(0.0,0.0,0.0,1);

        glClear(GL_COLOR_BUFFER_BIT + GL_DEPTH_BUFFER_BIT)

	if params.delta then
                millis = time + params.delta
        end

	glDisable(GL_TEXTURE_2D)
	glLoadIdentity()
	glPushMatrix()
	glEnable(GL_BLEND)
	glEnable(GL_MULTISAMPLE)
		glOrtho(0, glutGet(GLUT_WINDOW_WIDTH), 0, glutGet(GLUT_WINDOW_HEIGHT), 0, 100)
		glMatrixMode(GL_MODELVIEW)
--		glTranslated(0,2,3)
--		glScaled(0.2,0.2,0.2)

		local width = glutGet(GLUT_WINDOW_WIDTH)
		local height = glutGet(GLUT_WINDOW_HEIGHT)

		local vc = 1
		local do_transition = 0

		if (params.transition) then
				do_transition = params.transition
			end

		glBlendFunc(GL_SRC_ALPHA, GL_DST_COLOR)

		local colvar = 0

		if (do_transition == 3) then
		colvar = (millis-effu_start)*0.0003
		if colvar >= 2 then colvar = 2 end
		end

		if do_transition == 9 then
		colvar = 2-(millis-effu_start)*0.0003
		if colvar < 0 then colvar = 0 end
		end
		glColor4d(0.9, 0.2, 0.2, 0.25-(math.cos(millis*0.0008)*math.sin(millis*0.00035))*0.2-colvar*0.08)

		local tz = 0
		if do_transition == 0 then
		tz = -1.3+math.cos(millis*0.0001)*0.3
		else
		tz = -1.3
		end

		tm = math.cos(millis*0.0002)*5

		drawtrigs = 0
		if params.blackout then
			drawtrigs = 1
		end

		if drawtrigs == 0 then
			glEnable(GL_TEXTURE_2D)
			glBegin(GL_TRIANGLES)
				glTexCoord2d(5,5+tm)
				glVertex3d(width/2, height/1.1,tz)
				glTexCoord2d(-5,0+tm)
				glVertex3d(width/10,height/6,tz)
				glTexCoord2d(5,-5+tm)
				glVertex3d(width-width/10,height/6,tz)
			glEnd()
			glDisable(GL_TEXTURE_2D)
			glDisable(GL_BLEND)
			glColor4d(0.0, 0.0, 0.0, 1)
			tz = tz + 0.1
			glBegin(GL_TRIANGLES)
				glVertex3d(width/2, height/5.9,tz)
				glVertex3d(width/3,height/1.68,tz)
				glVertex3d(width-width/3,height/1.68,tz)
			glEnd()
		end
		glEnable(GL_BLEND)
		glBlendFunc(GL_SRC_COLOR, GL_DST_COLOR)

		glTranslated(width/2-(height/128)*64+math.sin(millis*0.001)*30,math.cos(millis*0.001)*20,0)

		for y = 0, 128-(colvar*0.7)*100, 2 do
			for x = 1, 128, 2 do
				local indexi = ((128-y)*128)+128-x
				--if params.pic == 0 then vc = tiedemies[indexi] end
				--if params.pic == 1 then vc = murkku[indexi] end
				--if params.pic == 2 then vc = samurai[indexi] end
				--if params.pic == 3 then vc = sulevi[indexi] end
				vc = tiedemies[indexi]

				breakflag = 0

				if vc == nil then vc = 0 end
				vc2 = tiedemies[indexi+1]
				if vc2 == nil then vc2 = 0 end
				vc = vc + vc2
				vc = vc / 2
				local fc = vc/255
				local alter = 0
				if fc > 0 then 
					fc = fc + beat*200
					alter = math.cos(millis*0.01)*0.3
				else
					breakflag = 1
				end


				local fc2 = fc

				if breakflag == 0 then
					if do_transition == 0 or do_transition == 2 or do_transition == 4 or do_transition == 5 or do_transition == 9 then 
						glColor4d(fc, fc, fc+alter, 0.7+math.cos(millis*0.02)*0.5)
					elseif do_transition == 3 then
						glColor4d(fc-colvar+(y*0.006), fc+colvar+(y*0.007), fc+alter-colvar, 0.7+math.cos(millis*0.02)*0.5)
					elseif do_transition == 1 then
						fc3 = (millis-effu_start)*0.00030
						if fc3 > 1.8 then fc3 = 1.8 end
						glColor4d(fc2-fc3, fc2-fc3, fc2-fc3+alter, 0.7+math.cos(millis*0.02)*0.5)
					else
						fc = fc - 0.8+math.cos((millis-effu_start)*0.0001)*(y/164)
						if fc < 0 then fc = 0 end
						glColor4d(fc, fc, fc+alter, 0.7+math.cos(millis*0.02)*0.5)
					end
					local vs = height/128
					local vx = 0
					if do_transition == 1 then
						vx = x*vs+math.cos((millis-effu_start)*0.0002+x*4+y*0.3)*(math.cos((millis-effu_start)*0.000005)*(width/2*((millis-effu_start)*0.001)))
					elseif do_transition == 2 then
						local exp_size = width/4-((millis-effu_start)*width/3000)
						if exp_size < 0 then exp_size = 0 end
						vx = x*vs+math.cos(millis*0.01+x+y*0.01)+(math.sin((millis-effu_start)*0.002+y)*exp_size)
					elseif do_transition == 3 then
						vx = x*vs+math.cos(millis*0.01+x+y*0.1)*(math.sin(millis*0.0001)*width/370)
					elseif do_transition == 4 then
						mover = transx[y]
						if transx[y] < width then transx[y] = (millis-effu_start)*width/5000*(y+10)*(0.05+(math.abs(math.cos(millis*0.0003+math.sin(y*0.01))*0.05+math.sin(y*0.1)*0.05))) end
						if y % 2 == 0 then
							vx = x*vs+math.cos(millis*0.01+x+y*0.1)*(math.sin(millis*0.0001)*width/370)+(width-mover)
						else
							vx = x*vs+math.cos(millis*0.01+x+y*0.1)*(math.sin(millis*0.0001)*width/370)-width+mover
						end
					elseif do_transition == 5 then
						local exp_size = width/2.5-((millis-effu_start)*width/2000)
						if exp_size < 0 then exp_size = 0 end
						vx = x*vs+math.cos(millis*0.01+x*0.01+exp_size*0.02)+(math.cos((millis-effu_start)*0.002+y+x)*exp_size)
					else
						vx = x*vs+math.cos(millis*0.01+x+y*0.1)*(math.sin(millis*0.0001)*width/370)
					end
					local vy = y*vs+math.sin(beat*3000*y*0.001+(y*3*beat))*height/360
					local z = -0.5+math.cos(millis*0.002+x*0.05+y*0.03)*0.5
					glBegin(GL_QUADS)
						glVertex3d(vx,vy+math.sin(vx%20*0.02)*beat*(height*250)+math.cos(millis*0.001)*(beat*height*30),z)
						glVertex3d(vx+vs*2,vy,z)
						glVertex3d(vx+vs*2,vy+vs*2,z)
						glVertex3d(vx-math.cos(vy)*beat*(width*50),vy+vs*2,z)
					glEnd()
				end
			end
		end

	glDisable(GL_MULTISAMPLE)
	glPopMatrix()
end

-- called after last _paint
function pic128_deinit()
	--print("pic128_deinit")
end

function pic128_unload()
	--print("pic128_unload")
end
