uniform sampler2D texture;
uniform float t;

const float pi = 3.141592653;
const vec4 fogColor = vec4(0.0, 0.0, 0.0, 0.0);

void main() {
	vec2 xy = gl_TexCoord[0].xy;
	vec4 color = texture2D(texture, xy);

	float phase = 64.0*pi;
	float p1 = 4.0;
	float p2 = 6.4;
	float p3 = 7.5;
	float x = sin(xy.x*p1+sin(xy.x*p2));
	float y = sin(xy.y*p3+sin(xy.y*p1));
	float v = sin(x*phase)+sin(y*phase*64.0);
	color = vec4(v, v, v, v);

	const float LOG2 = 1.442695;
	const float fogDensity = 0.0005;
	float z = gl_FragCoord.z / gl_FragCoord.w;
	float fogFactor = exp2(-fogDensity*fogDensity*z*z*LOG2);
	fogFactor = clamp(fogFactor, 0.0, 1.0);

	gl_FragColor = mix(fogColor, color, fogFactor);
}