
#ifndef NUM_LIGHTS
	#define NUM_LIGHTS 1
#endif

varying vec3 normal;
varying vec3 lightDir[NUM_LIGHTS];
varying vec3 eye;
varying float camdot;

uniform float sidemul;

void main() {
	gl_TexCoord[0] = gl_TextureMatrix[0]*gl_MultiTexCoord0;

	vec4 tangent = gl_MultiTexCoord7;

	vec3 n = normalize(gl_NormalMatrix*gl_Normal);
	vec3 t = normalize(gl_NormalMatrix*tangent.xyz);
	vec3 b = cross(n, t)*(sidemul*tangent.a);

	vec4 pos = gl_ModelViewMatrix*gl_Vertex;

	camdot = 1.0-dot(n, normalize(-pos.xyz));
	camdot = camdot*camdot*camdot*2.0;

	vec3 tmpVec;
	for (int i = 0; i < NUM_LIGHTS; i++) {
		tmpVec = vec3(normalize(vec3(0.0, 1.0, -1.0))-pos);

		lightDir[i].x = dot(tmpVec, t);
		lightDir[i].y = dot(tmpVec, b);
		lightDir[i].z = dot(tmpVec, n)*sidemul;
	}

	tmpVec = -pos.xyz;
	eye.x = dot(tmpVec, t);
	eye.y = dot(tmpVec, n);
	eye.z = dot(tmpVec, b);

	normal = n;

	gl_Position = ftransform();
}
