
//#define NO_BLACK
//#define NO_SPECULAR

const vec4 spec = vec4(0.25, 0.2, 0.15, 1.0);

uniform sampler2D texture;
uniform float radius;
uniform float xresm;	// 1.0/xres
uniform float yresm;	// 1.0/yres
uniform float specangle;
uniform float lightbri;
uniform float mixorig;
uniform vec3 eye;

// Returns height of a pixel. Notice that the height isn't normalized (meaning that result is between 0.0 to 3.0)
float getHeight(vec2 texcoord) {
	vec4 col = texture2D(texture, texcoord);
	return col.r+col.g+col.b;
}

vec2 getNormal(vec2 tc) {
	float xp = 1.0/xresm*radius;
	float yp = 1.0/yresm*radius;

	float x0 = getHeight(tc-vec2(xp, 0.0))/3.0;
	float x2 = getHeight(tc+vec2(xp, 0.0))/3.0;
	float y0 = getHeight(tc-vec2(0.0, yp))/3.0;
	float y2 = getHeight(tc+vec2(0.0, yp))/3.0;

	float dh = x0-x2;
	float dv = y0-y2;

	// no black
	if (dh == 0.0) dh = 0.0001;

	return normalize(vec2(dh, dv));
}

void main() {
	vec2 normal = getNormal(gl_TexCoord[0].xy);
	vec4 origcolor = texture2D(texture, gl_TexCoord[0].xy);// + newDir*displacement);

	vec2 lightDir = normalize(vec2(origcolor.x, origcolor.y)/origcolor.z);

	vec2 newDir = normalize(reflect(normalize(lightDir), normal));
//	newDir *= vec2(xresm, yresm);
	newDir.x /= xresm;
	newDir.y /= yresm;

	float diff = dot(normal, lightDir)*lightbri;

	vec2 r = reflect(-lightDir, normal);
	float fspec = pow(abs(dot(r, normalize(vec3(0.0, -1.0, 0.25)))), 16.0);

	vec4 color = origcolor*diff + origcolor*fspec;

	gl_FragColor = mix(color, origcolor, mixorig) + fspec*spec;

}
