#include version.txt

varying vec2 Texcoord;

varying vec4 c1;
varying vec4 c2;
varying vec4 c3;

void main( void )
{
	vec3 normal, lightDir;
	vec4 diffuse;
	float NdotL;

	normal =  normalize(gl_NormalMatrix * gl_Normal);
	// --- Light 1 ---
	lightDir = normalize(vec3(gl_LightSource[0].position));
	NdotL = max(dot(normal, lightDir), 0.0);
//	diffuse = gl_FrontMaterial.diffuse * gl_LightSource[0].diffuse;
	c1 = NdotL * gl_LightSource[0].diffuse;
	// --- Light 2 ---
	lightDir = normalize(vec3(gl_LightSource[1].position));
	NdotL = max(dot(normal, lightDir), 0.0);
//	diffuse = gl_FrontMaterial.diffuse * gl_LightSource[1].diffuse;
	c2 = NdotL * gl_LightSource[1].diffuse;
	// --- Light 3 ---
	lightDir = normalize(vec3(gl_LightSource[2].position));
	NdotL = max(dot(normal, lightDir), 0.0);
//	diffuse = gl_FrontMaterial.diffuse * gl_LightSource[2].diffuse;
	c3 = NdotL * gl_LightSource[2].diffuse;
	
    Texcoord    = (gl_TextureMatrix[0]*gl_MultiTexCoord0).xy;
	gl_Position = ftransform();	
}

