#include version.txt

varying vec3 normal,lightDir,halfVector;
uniform vec3 LightPos;
varying float eyeZ;

void main()
{	
	vec4 ecPos;
	vec3 aux;

	normal = normalize(gl_NormalMatrix * gl_Normal);
	ecPos = gl_ModelViewMatrix * gl_Vertex;
	vec4 iLightPos = gl_ModelViewMatrix * vec4(LightPos, 1.0);
	aux = vec3(iLightPos - ecPos);
	lightDir = normalize(aux);
	halfVector = normalize(gl_LightSource[0].halfVector.xyz);
	gl_Position = ftransform();

    eyeZ = 1.0 - (gl_Position.z / gl_Position.w);
} 
