#include version.txt

uniform float Time;
uniform float PointSize;
uniform vec3 dir;
uniform float TimeCap;

attribute vec3 Velocity;
attribute float StartTime;

void main( void )
{
    vec4 vert;
    float t = Time - StartTime;
    t = mod(t, TimeCap);
	vert = gl_Vertex + vec4(dir * Velocity.x * t, 0.0);
	float dist = -(gl_ModelViewMatrix * vert).z;
	gl_PointSize = (PointSize / dist);
    gl_Position = gl_ModelViewProjectionMatrix * vert;
}
