#include version.txt

uniform float scale;
varying vec4 c1;
varying vec4 c2;

void main(void) {
    
	vec4 v = vec4(gl_Vertex.x, gl_Vertex.y * scale, gl_Vertex.z, 1.0);
	
	vec3 normal, lightDir;
	vec4 diffuse;
	float NdotL;

	normal =  normalize(gl_NormalMatrix * gl_Normal);
	
	// --- Light 1 ---
	lightDir = normalize(vec3(gl_LightSource[0].position));
	NdotL = max(dot(normal, lightDir), 0.0);
	diffuse = gl_FrontMaterial.diffuse * gl_LightSource[0].diffuse;
	c1 =  NdotL * diffuse;
	
	// --- Light 2 ---
	lightDir = normalize(vec3(gl_LightSource[1].position));
	NdotL = max(dot(normal, lightDir), 0.0);
	diffuse = gl_FrontMaterial.diffuse * gl_LightSource[1].diffuse;
	c2 =  NdotL * diffuse;
	
    gl_Position = gl_ModelViewProjectionMatrix * v;
}
