#include version.txt

uniform sampler2D tex;
uniform float num_pixels;

void main() {
  
  float np = num_pixels * 256.0;

  float xc = gl_TexCoord[0].x;
  xc = xc * np;
  xc = floor(xc);
  xc = xc / np;

  float yc = gl_TexCoord[0].y;
  yc = yc * np;
  yc = floor(yc);
  yc = yc / np;

  gl_FragColor = texture2D(tex, vec2(xc, yc));
}
