#include version.txt

uniform sampler2D Texture0;
uniform sampler2D Texture1;
uniform sampler2D Texture2;

uniform float Brightness;
uniform float Contrast;
uniform float NoiseFrame;
uniform float NoiseSpeed;
uniform float NoiseRamp;

varying vec2 texCoord;
varying vec2 texCoord2;

void main(void)
{
   vec4 original = texture2D(Texture0, texCoord);
   vec4 brightness = vec4(Brightness, Brightness, Brightness, 0.0);
   vec4 contrast = vec4(Contrast, Contrast, Contrast, 0.0);
   vec4 BC = (original + brightness) * (vec4(1.0, 1.0, 1.0, 1.0) + contrast) / vec4(1.0, 1.0, 1.0, 1.0);

   vec4 hNoise = texture2D(Texture1, texCoord2);
   vec4 hNoiseCol = hNoise * BC;
   
   vec4 tvnoise = texture2D(Texture2, texCoord);
   float tvnoisecol = mod((tvnoise[0] * NoiseRamp) + (NoiseFrame * NoiseSpeed), 1.0);

   vec4 semiFinalCol = hNoiseCol / vec4(tvnoisecol);
   
   if (mod((texCoord.x + texCoord.y) * 0.35, 0.01) > 0.005) {
      gl_FragColor = mix(semiFinalCol, vec4(0.0, 0.0, 0.0, 1.0), 0.5);
   }
   else {
      gl_FragColor = semiFinalCol;
   }

}
