#version 330 core

uniform mat4 ModelViewProjectionMatrix;
uniform mat4 ModelViewMatrix;
uniform mat3 NormalMatrix;
uniform float time;

in vec3 POSITION;
in vec3 NORMAL;
in vec2 TEXCOORD;

out vec3 ec_pos;
out vec3 normal;
out vec2 uv;
out vec2 uv2;
out vec3 offset_y;
out vec2 pos_zw;

void main()
{
	uv = TEXCOORD;
	uv2 = vec2(0.5) + (POSITION.xz - vec2(0.0, -3.6)) / 8.0;

	float a = time*8.0 + length(POSITION.xz)*(1.0/128.0);
	vec2 angles = POSITION.xz*(1.0/128.0) + vec2(sin(a), cos(a));
	offset_y.xy = vec2(cos(angles.x), sin(angles.y))*0.25;
	offset_y.z = POSITION.y;
	normal = NormalMatrix * vec3(0.0, 1.0, 0.0); //NORMAL;
	ec_pos = vec3(ModelViewMatrix * vec4(POSITION, 1.0));
	vec4 proj_pos = ModelViewProjectionMatrix * vec4(POSITION, 1.0);
	pos_zw = proj_pos.zw;
	gl_Position = proj_pos;
}
