#version 330 core

uniform mat4 ModelViewProjectionMatrix;
uniform mat4 ModelViewMatrix;
uniform mat3 NormalMatrix;

uniform vec3 XAxis;
uniform vec3 YAxis;

in vec3 gs_params[1]; // radius, energy, 1/mass

out vec4 ec_pos;
out vec4 normal;
out vec2 uv;

layout(points) in;
layout(triangle_strip, max_vertices = 4) out;

#define EMIT_VERTEX(VTX, UV) \
	uv = UV; \
	normal.rgb = n; \
	normal.a = alpha; \
	ec_pos.xyz = vec3(ModelViewMatrix * vec4(VTX, 1.0)); \
	ec_pos.w = VTX.y; \
	gl_Position = ModelViewProjectionMatrix * vec4(VTX, 1.0); \
	EmitVertex()

void main()
{
	vec3 n = NormalMatrix * vec3(0.0, 0.0, -1.0);
	//vec3 n = NormalMatrix * vec3(0.0, 1.0, 0.0);
	vec3 pos = gl_in[0].gl_Position.xyz;
	float radius = gs_params[0].x;

	vec3 cp = vec3(ModelViewMatrix * vec4(gl_in[0].gl_Position.xyz, 1.0));
	float dist = dot(vec3(0.0, 0.0, -1.0), cp) - 1.0;
	float alpha = smoothstep(0.0, 0.5, dist);

	vec3 a = pos + (XAxis + YAxis)*radius;
	vec3 b = pos + (YAxis - XAxis)*radius;
	vec3 c = pos + (-XAxis - YAxis)*radius;
	vec3 d = pos + (XAxis - YAxis)*radius;

	EMIT_VERTEX(a, vec2(1.0, 0.0));
	EMIT_VERTEX(b, vec2(0.0, 0.0));
	EMIT_VERTEX(d, vec2(1.0, 1.0));
	EMIT_VERTEX(c, vec2(0.0, 1.0));

	EndPrimitive();
}
