#version 330 core

uniform mat4 ModelViewProjectionMatrix;
uniform mat4 ProjectionMatrix;

uniform vec3 XAxis;
uniform vec3 YAxis;

in vec3 gs_params[1]; // radius, energy, 1/mass

out vec3 wpos;
out vec2 uv;
out vec2 proj_uv;

layout(points) in;
layout(triangle_strip, max_vertices = 4) out;

vec2 planarProjection(in vec3 vtx)
{
	const float centerX = 0.0;
	const float centerY = 20.0;
	const float sizeX = 32.0;
	const float sizeY = 40.0;
	vec2 uv;
	uv.x = 0.5 + ((vtx.x - centerX) / sizeX);
	uv.y = 0.5 + ((vtx.y - centerY) / sizeY);
	return uv;
}


#define EMIT_VERTEX(VTX, UV) \
	uv = UV; \
	proj_uv = planarProjection(VTX); \
	wpos = VTX; \
 	gl_Position = ModelViewProjectionMatrix * vec4(VTX, 1.0); \
	EmitVertex()

void main()
{
	vec3 pos = gl_in[0].gl_Position.xyz;
	float radius = gs_params[0].x;

	if ( radius > 0.0 )
	{
		float dist = dot(vec3(0.0, 0.0, -1.0), pos) - 1.0;
		float particle_alpha = smoothstep(0.0, 1.0, dist);

		vec3 a = pos + (XAxis + YAxis)*radius;
		vec3 b = pos + (YAxis - XAxis)*radius;
		vec3 c = pos + (-XAxis - YAxis)*radius;
		vec3 d = pos + (XAxis - YAxis)*radius;

		EMIT_VERTEX(a, vec2(1.0, 1.0));
		EMIT_VERTEX(b, vec2(0.0, 1.0));
		EMIT_VERTEX(d, vec2(1.0, 0.0));
		EMIT_VERTEX(c, vec2(0.0, 0.0));

		EndPrimitive();
	}
}
