#version 330 core

uniform float deltaTime;
uniform vec2  direction;
uniform sampler2D noise;

in vec4 POSITION;
//in vec4 COLOR;

//out vec4 gs_color;

vec3 apply_force(in vec3 pos, in vec3 center, in float radius, in float angle)
{
	vec3 dir = center - pos;
	vec3 force = vec3(0.0);
	float dist = length(dir);
	if ( dist < radius )
	{
		float d = pow(1.0 - dist*(1.0/radius), 4.0) * angle*4.0;
		//float d = pow(dist*(1.0/radius), 4.0) * angle;
		float c = cos(d);
		float s = sin(d);
		dir = normalize(dir);
		force.x = c*dir.x - s*dir.z;
		force.z = s*dir.x + c*dir.z;
		force.y = s*dir.y + c*dir.x;
	}

	return force;
}

void main()
{
	//float scale = smoothstep(0.3, 0.6, 1.0 - POSITION.w) * 1.0 * deltaTime;
	//float y_scale = smoothstep(0.2, 0.4, 1.0 - POSITION.w) * 0.5 * deltaTime;
	float scale = smoothstep(0.3, 0.6, 1.0 - POSITION.w) * deltaTime;
	float y_scale = smoothstep(0.2, 0.4, 1.0 - POSITION.w) * 0.5 * deltaTime;

	//vec3 n = normalize(POSITION.xyz);
	vec3 pos = POSITION.xyz;//*0.04;
	//vec4 offset = textureLod(noise, pos.xz + vec2(pos.y*8.0, pos.y*5.0), 0.0).rbga*2.0 - vec4(1.0);
	vec4 offset = textureLod(noise, pos.xz + vec2(pos.z*8.0, pos.y*8.0), 0.0).rbga*2.0 - vec4(1.0);
	//vec4 offset = textureLod(noise, pos.xz + vec2(0.0, POSITION.y), 0.0).rbga*2.0 - vec4(1.0);
	//offset.xz *= 2.0;

	vec3 fpos = POSITION.xyz + vec3(direction.x, 0.0, direction.y);
	vec3 dir = apply_force(fpos, vec3(-0.1, 0.0, -8.5), 15.0, 6.0);
	dir += apply_force(fpos, vec3(-0.2, 0.0, -1.5), 15.0, -6.0);
	dir += apply_force(fpos, vec3(0.3, 0.0, 6.5), 15.0, 6.0);

	offset.xyz += dir;

	offset.x *= scale;
	offset.y = (offset.y + 0.1)*y_scale;
	offset.z *= scale;

	offset.w = -(1.0/16.0)*deltaTime;

	//gs_color = COLOR;
	gl_Position = POSITION + offset;
}
