#version 330 core

uniform sampler2D particle;
uniform sampler2D normal_depth;
uniform vec2 viewport;

in float intensity;
in vec3 wpos;

layout (location = 0) out vec4 frag_color;

#include <gbuffer_include.frag>


void main()
{
	const vec4 blue = vec4(53.f/255.0, 62.0/255.0, 93.0/255.0, 1.0);
	const vec4 orange = vec4(93.f/255.0, 62.0/255.0, 53.0/255.0, 1.0);

	vec4 p = texture(particle, gl_PointCoord).rrrr*mix(orange, blue, smoothstep(0.85, 1.0, intensity));
	if ( p.r < (1.0/255.0) ) discard;

	vec2 uv_pos = gl_FragCoord.xy * viewport;
	vec4 nd = texture(normal_depth, uv_pos);
	vec3 pos = calc_position(uv_pos, nd.w);

	if ( pos.z > wpos.z ) discard;
	float alpha = clamp((wpos.z - pos.z)*100.0, 0.0, 1.0);

	frag_color = p*alpha*intensity;
}
