#version 330 core

uniform sampler2D flow;
uniform sampler2D feedback;
uniform sampler2D tex;
uniform vec2      TexelSize;
uniform vec2      direction;
uniform float     deltaTime;
uniform float     time;

in vec2 uv;

layout (location = 0) out vec4 frag_color;

vec4 calc_feedback_flow()
{
	vec3 f = texture(flow, uv*0.25).rgb;
	vec2 flow_uv = ((f.rg*2.0 - vec2(1.0)) + direction) * TexelSize * 32.0;
	flow_uv.x *= 2.0;

	float flow_offset0 = mod(time, 1.0);
	float flow_offset1 = mod(time + 0.5, 1.0);
	float cycle_offset = f.b;
	float phase0 = cycle_offset*0.5 + flow_offset0;
	float phase1 = cycle_offset*0.5 + flow_offset1;
	float k = abs(0.5 - flow_offset0) / 0.5;

	vec4 fb = mix( texture(feedback, uv - flow_uv*phase0), texture(feedback, uv - flow_uv*phase1), k);
	fb = (fb + texture(feedback, uv - direction*TexelSize)) / 2.0;
	fb = (fb + texture(feedback, uv)) / 2.0;

	vec4 tb = texture(tex, uv);
	tb.rgb *= tb.a;

	return (fb*1.1)*(1.0 - tb.a) + tb;
}

void main()
{
	float x_scale = smoothstep(0.0, 0.2, uv.x) * (1.0 - smoothstep(0.8, 1.0, uv.x));
	float y_scale = smoothstep(0.0, 0.2, uv.y) * (1.0 - smoothstep(0.8, 1.0, uv.y));
	frag_color = calc_feedback_flow() * y_scale * x_scale;
}
