#version 330 core

uniform mat4 ModelViewProjectionMatrix;
uniform mat4 ModelViewMatrix;
uniform sampler2D flow;
uniform float time;
uniform vec3 offsetPosition;
uniform vec3 scale;

in vec3 gs_normal[3];
in vec2 gs_uv[3];

out vec3 ec_pos;
out vec2 pos_zw;
out vec2 uv;

#define EMIT_VERTEX(VTX, EYE, UV) \
	ec_pos = EYE; \
	pos_zw = VTX.zw; \
	uv = UV; \
	gl_Position = VTX; \
	EmitVertex()

vec3 tetrahedron_vertices[4] = vec3[](
	vec3( 1.0,  1.0,  1.0),
	vec3(-1.0, -1.0,  1.0),
	vec3(-1.0,  1.0, -1.0),
	vec3( 1.0, -1.0, -1.0)
);

layout(triangles) in;
layout(triangle_strip, max_vertices=9) out;

#include <matrix_include.vert>

void main()
{
	vec3 center = (gl_in[0].gl_Position.xyz + gl_in[1].gl_Position.xyz + gl_in[2].gl_Position.xyz) / 3.0;
	vec3 centerOffset = center + offsetPosition;
	vec3 e0 = gl_in[1].gl_Position.xyz - gl_in[0].gl_Position.xyz;
	vec3 e1 = gl_in[2].gl_Position.xyz - gl_in[0].gl_Position.xyz;
	float radius = 0.5 * length(cross(e0, e1)) * (1.0 - smoothstep(0.0, 1.0, (time - center.z)*0.0625));

	if ( centerOffset.z < time )
	{
		if ( radius < 0.001 ) return;

		float k = (time - centerOffset.z);
		vec3 center_normal = normalize(cross(e0, e1));

		vec3 offset = textureLod(flow, centerOffset.xz*0.25, 0.0).rbg*2.0 - vec3(1.0);
#if 0
		//offset.x = -(center.x*0.5 - sign(center.x))*smoothstep(0.3, 5.0, (time - center.z))*3.0;
		offset.x = (offset.x*0.5 - sign(centerOffset.x))*smoothstep(0.3, 5.0, k)*7.0;
		offset.y = smoothstep(0.0, 2.7, k)*5.0;
		offset.z = smoothstep(0.3, 6.0, k)*k*2.0;
#else
		offset.x = (offset.x*0.5 - sign(centerOffset.x))*smoothstep(0.3, 5.0, k);
		offset.y = smoothstep(0.0, 2.7, k);
		offset.z = smoothstep(0.3, 6.0, k)*k;
		offset *= scale;
#endif

		mat3 mr;
		float angle = (time - center.z)*0.57;
		rotate_around_axis(center_normal, angle, mr);

		vec4 vertices[4];
		vec3 ec_eye[4];
		vec2 tetra_uv[4];
		for (int i=0; i < 4; i++)
		{
			vec4 pos = vec4(center + offset + mr*tetrahedron_vertices[i]*radius, 1.0);
			tetra_uv[i] = (center.xz + tetrahedron_vertices[i].xz*radius) * (1.0/1.0);
			ec_eye[i] = vec3(ModelViewMatrix * pos);
			vertices[i] = ModelViewProjectionMatrix * pos;
		}

		EMIT_VERTEX(vertices[0], ec_eye[0], tetra_uv[0]);
		EMIT_VERTEX(vertices[1], ec_eye[1], tetra_uv[1]);
		EMIT_VERTEX(vertices[3], ec_eye[3], tetra_uv[3]);
		EMIT_VERTEX(vertices[2], ec_eye[2], tetra_uv[2]);
		EMIT_VERTEX(vertices[0], ec_eye[0], tetra_uv[0]);
		EMIT_VERTEX(vertices[1], ec_eye[1], tetra_uv[1]);
		EndPrimitive();
	}
	else
	{
		for (int i=0; i < 3; i++)
		{
			vec4 pos = gl_in[i].gl_Position;
			vec4 vtx = ModelViewProjectionMatrix * pos;
			ec_pos = vec3(ModelViewMatrix * pos);
			pos_zw = vtx.zw;
			uv = gs_uv[i];
			gl_Position = vtx;
			EmitVertex();
		}
		EndPrimitive();
	}
}

