#version 330 core

uniform sampler2D diffuse;
uniform sampler2D specular;
uniform sampler2D bumpmap;

in vec3 ec_pos;
in vec2 pos_zw;
in vec2 uv;

layout (location = 0) out vec4 diffuse_specular;
layout (location = 1) out vec4 normal_depth;

#include <tangentspace_include.frag>

void main()
{
	vec3 t, b;
	per_fragment_tangent_space(ec_pos, uv, t, b);

	vec3 normal = normalize( cross(dFdx(ec_pos), dFdy(ec_pos)) );

	vec4 bm = texture2D(bumpmap, uv);
	vec3 bump = normalize(bm.rgb*2.0 - vec3(1.0));

	mat3 mr = mat3(t, b, normalize(normal));
	vec3 n = mr * bump;

	diffuse_specular.rgb = texture2D(diffuse, uv).rgb;
	diffuse_specular.a = texture2D(specular, uv).r;

	normal_depth.rgb = n;
	normal_depth.a = pos_zw.x/pos_zw.y;
}

