#version 330 core

uniform sampler2D light_accumulation;

uniform vec2 Direction;
uniform vec2 TexelSize;
uniform vec4 Weights;
uniform float B;

in vec2 uv;

layout (location = 0) out vec4 frag_color;

void main()
{
#define LOD_LEVEL 0.0

	vec2 sc = Direction*TexelSize*B;

	vec4 color = textureLod(light_accumulation, uv, LOD_LEVEL)*Weights.x;

	color += textureLod(light_accumulation, uv + sc, LOD_LEVEL)*Weights.y;
	color += textureLod(light_accumulation, uv - sc, LOD_LEVEL)*Weights.y;

	sc += sc;
	color += textureLod(light_accumulation, uv + sc, LOD_LEVEL)*Weights.z;
	color += textureLod(light_accumulation, uv - sc, LOD_LEVEL)*Weights.z;

	sc += sc;
	color += textureLod(light_accumulation, uv + sc, LOD_LEVEL)*Weights.w;
	color += textureLod(light_accumulation, uv - sc, LOD_LEVEL)*Weights.w;

	//frag_color = vec4(color.rgb*color.a, 1.0);
	frag_color = vec4(color.rgb, 1.0);
	//frag_color = vec4(color.aaa, 1.0);
}
