#version 330 core

uniform sampler2D grass;
uniform sampler2D oat;
uniform sampler2D specular;

in vec2 pos_zw;
in vec3 normal;
in vec3 uv_blend;

layout (location = 0) out vec4 diffuse_specular;
layout (location = 1) out vec4 normal_depth;

void main()
{
	vec4 diff = mix( texture(grass, uv_blend.xy), texture(oat, uv_blend.xy), uv_blend.z);
	if ( diff.a < 0.2 ) discard;

	float front = gl_FrontFacing ? 1.0 : -1.0;

	diffuse_specular.rgb = diff.rgb*2.0;
	diffuse_specular.a = texture(specular, uv_blend.xy).r;

	normal_depth.xyz = normalize(normal*front);
	normal_depth.w = pos_zw.x/pos_zw.y;
}
