#version 330 core

uniform mat4 ModelViewProjectionMatrix;
uniform mat4 ModelViewMatrix;
uniform mat3 NormalMatrix;
uniform float offset;

in vec3 gs_normal[3];
in vec2 gs_uv[3];

out vec2 pos_zw;
out vec3 normal;
out vec2 uv;
out vec3 ec_pos;

layout(triangles) in;
layout(triangle_strip, max_vertices=3) out;

void main()
{
#if 0
	vec3 center = (gl_in[0].gl_Position.xyz + gl_in[1].gl_Position.xyz + gl_in[2].gl_Position.xyz) / 3.0;
	vec2 uv_center = (gs_uv[0] + gs_uv[1] + gs_uv[2]) / 3.0;
	float scale = clamp(offset - center.z, 0.0, 1.0);
#else
	float center_z = (gl_in[0].gl_Position.z + gl_in[1].gl_Position.z + gl_in[2].gl_Position.z) / 3.0;
	vec3 center = gl_in[0].gl_Position.xyz;
	vec2 uv_center = gs_uv[0];
	if ( gl_in[1].gl_Position.z < center.z )
	{
		center = gl_in[1].gl_Position.xyz;
		uv_center = gs_uv[1];
	}
	if ( gl_in[2].gl_Position.z < center.z )
	{
		center = gl_in[2].gl_Position.xyz;
		uv_center = gs_uv[2];
	}
	float scale = clamp(offset - center_z, 0.0, 1.0);
#endif

	if ( scale < 1.0 )
	{
		for (int i=0; i < 3; i++)
		{
			uv = uv_center + (gs_uv[i] - uv_center)*scale;
			normal = NormalMatrix * gs_normal[i];

			vec4 pos = vec4(center + (gl_in[i].gl_Position.xyz - center)*scale, 1.0);
			vec4 proj_pos = ModelViewProjectionMatrix * pos;
			pos_zw = proj_pos.zw;
			ec_pos = vec3(ModelViewMatrix * pos);
			gl_Position = proj_pos;
			EmitVertex();
		}
		EndPrimitive();
	}
	else
	{
		for (int i=0; i < 3; i++)
		{
			uv = gs_uv[i];
			normal = NormalMatrix * gs_normal[i];

			vec4 pos = gl_in[i].gl_Position;
			vec4 proj_pos = ModelViewProjectionMatrix * pos;
			pos_zw = proj_pos.zw;
			ec_pos = vec3(ModelViewMatrix * pos);
			gl_Position = proj_pos;
			EmitVertex();
		}
		EndPrimitive();
	}
}
