#define USE_PROJECTION_COEFFS

#ifdef USE_PROJECTION_COEFFS

// inverse projection coeffs
uniform float projCoeffs[5];

vec3 calc_position(in vec2 uv_pos, in float d)
{
	vec4 pos = vec4((uv_pos.x - 0.5)*2.0, (uv_pos.y - 0.5)*2.0, d, 1.0);

	vec4 wpos;
	wpos.x = pos.x*projCoeffs[0];
	wpos.y = pos.y*projCoeffs[1];
	wpos.z = pos.w*projCoeffs[2];
	wpos.w = pos.z*projCoeffs[3] + pos.w*projCoeffs[4];

	return wpos.xyz / wpos.w;
}

#else // !USE_PROJECTION_COEFFS

uniform mat4 ProjectionMatrixInverse;

vec3 calc_position(in vec2 uv_pos, in float d)
{
	vec4 wpos = vec4((uv_pos.x - 0.5)*2.0, (uv_pos.y - 0.5)*2.0, d, 1.0);

	wpos = ProjectionMatrixInverse * wpos;

	return wpos.xyz / wpos.w;
}

#endif
