#version 330 core

uniform sampler2D diffuse;
uniform sampler2D specular;
uniform sampler2D bumpmap;

in vec3 ec_pos;
in vec2 pos_zw;
in vec2 uv;

layout (location = 0) out vec4 diffuse_specular;
layout (location = 1) out vec4 normal_depth;

#include <tangentspace_include.frag>

void main()
{
	vec3 t, b, n;
	n = normalize( cross(dFdx(ec_pos), dFdy(ec_pos)) );
#if 0
	vec3 p = vec3(ec_pos.w, pos_zw.zw);
	float dx = dot(vec3(1.0, 0.0, 0.0), p);
	float dy = dot(vec3(0.0, 1.0, 0.0), p);
	float dz = dot(vec3(0.0, 0.0, 1.0), p);

	vec2 uv = (ec_pos.yz*dx + ec_pos.xz*dy + ec_pos.xy*dz);
#endif
	diffuse_specular.rgb = texture2D(diffuse, uv).rgb;
	diffuse_specular.a = texture2D(specular, uv).r;

	per_fragment_tangent_space(ec_pos, uv, t, b);
	vec3 bump = normalize(texture2D(bumpmap, uv).xyz*2.0 - vec3(1.0));	
	mat3 mr = mat3(t, b, n);

	normal_depth.rgb = mr * bump;
	normal_depth.a = pos_zw.x/pos_zw.y;
}
