#define PI 3.1415926535897932384626433832795
#define PI_OVER_TWO 1.5707963267948966192313216916398

vec3 twist_x(in vec3 pos, in vec3 center, in float radius, in float angle)
{
	vec3 p = pos - center;

	float d = p.x / radius;
	float c = cos(d*angle);
	float s = sin(d*angle);
	float y = pos.y;
	p.y = c*p.y - s*p.z;
	p.z = s*y + c*p.z;

	return p + center;
}

vec3 twist_y(in vec3 pos, in vec3 center, in float radius, in float angle)
{
	vec3 p = pos - center;

	float d = p.y / radius;
	float c = cos(d*angle);
	float s = sin(d*angle);
	float x = pos.y;
	p.x = c*p.x - s*p.z;
	p.z = s*x + c*p.z;

	return p + center;
}

vec3 twist_z(in vec3 pos, in vec3 center, in float radius, in float angle)
{
	vec3 p = pos - center;

	float d = p.z / radius;
	float c = cos(d*angle);
	float s = sin(d*angle);
	float x = pos.y;
	p.x = c*p.x - s*p.y;
	p.y = s*x + c*p.y;

	return p + center;
}

vec3 vortex_x(in vec3 pos, in vec3 center, in float radius, in float angle)
{
	vec3 p = pos - center;
	float len = length(p);
	float d = cos( (p.x / radius) * PI_OVER_TWO );
	d *= 1.f - (len <= radius ? len/radius : 1.0);
	float c = cos(angle*d);
	float s = sin(angle*d);
	float y = p.y;
	p.y = c*p.y + s*p.z;
	p.z = -s*y + c*p.z;
	return p + center;
}


vec3 vortex_y(in vec3 pos, in vec3 center, in float radius, in float angle)
{
	vec3 p = pos - center;
	float len = length(p);
	float d = cos( (p.y / radius) * PI_OVER_TWO );
	d *= 1.f - (len <= radius ? len/radius : 1.0);
	float c = cos(angle*d);
	float s = sin(angle*d);
	float x = p.x;
	p.x = c*p.x - s*p.z;
	p.z = s*x + c*p.z;
	return p + center;
}


vec3 vortex_z(in vec3 pos, in vec3 center, in float radius, in float angle)
{
	vec3 p = pos - center;
	float len = length(p);
	float d = cos( (p.z / radius) * PI_OVER_TWO );
	d *= 1.f - (len <= radius ? len/radius : 1.0);
	float c = cos(angle*d);
	float s = sin(angle*d);
	float x = p.x;
	p.x = c*p.x + s*p.y;
	p.y = -s*x + c*p.y;
	return p + center;
}

vec3 bend_x(in vec3 pos, in vec3 center, in float radius, in float angle)
{
	vec3 p = pos - center;
	float r = radius / angle;
	float y = p.y;
	float z = p.z;
	float zr = z / r;
	float c = cos(PI - zr);
	float s = sin(PI - zr);
	p.y = r*c + r - c*y;
	p.z = r*s - y*s;
	return p + center;
}

vec3 bend_y(in vec3 pos, in vec3 center, in float radius, in float angle)
{
	vec3 p = pos - center;
	float r = radius / angle;
	float x = p.x;
	float z = p.z;
	float zr = z / r;
	float c = cos(PI - zr);
	float s = sin(PI - zr);
	p.y = r*c + r - c*z;
	p.z = r*s - z*s;	
	return p + center;
}

vec3 bend_z(in vec3 pos, in vec3 center, in float radius, in float angle)
{
	vec3 p = pos - center;
	float r = radius / angle;
	float x = p.x;
	float y = p.y;
	float yr = y / r;
	float c = cos(PI - yr);
	float s = sin(PI - yr);
	p.x = r*c + r - c*x;
	p.y = r*s - x*s;	
	return p + center;
}
