#version 330 core
uniform mat4 ModelViewProjectionMatrix;
uniform mat4 ModelViewMatrix;
uniform mat3 NormalMatrix;
uniform float NormalOffset;

in vec3 POSITION;
in vec3 NORMAL;
in vec2 TEXCOORD;

out vec3 light_pos; //x,y,z
out vec2 uv;

void main()
{
	vec3 pos = POSITION + NORMAL*NormalOffset;
	light_pos = vec3(ModelViewMatrix * vec4(pos, 1.0));
	uv = TEXCOORD;
	gl_Position = ModelViewProjectionMatrix * vec4(POSITION, 1.0);
}
