#version 330 core

uniform sampler2D diffuse;
uniform sampler2D specular;
uniform sampler2D bumpmap;

in vec2 pos_zw;
in vec3 normal;
in vec3 ec_pos;
in vec2 uv;

layout (location = 0) out vec4 diffuse_specular;
layout (location = 1) out vec4 normal_depth;

#include <geometry_include.frag>
#include <tangentspace_include.frag>

void main()
{
	vec3 t, b;
	per_fragment_tangent_space(ec_pos, uv, t, b);

	vec4 diff_alpha = texture(diffuse, uv);
	//diff_alpha.a *= 0.75;
	diff_alpha.rgb *= diff_alpha.a;

	vec4 bm = texture2D(bumpmap, uv);
	vec3 bump = normalize(bm.rgb*2.0 - vec3(1.0));

	mat3 mr = mat3(t, b, normalize(normal));
	vec3 n = mr * bump;

	diffuse_specular = diff_alpha;

	//float front = 1.0;//gl_FrontFacing ? 1.0 : -1.0;
	normal_depth.rgb = normalize(n)*diff_alpha.a;
	normal_depth.a = diff_alpha.a;
}
