#version 330 core

uniform mat4 ModelViewProjectionMatrix;
uniform mat4 ModelViewMatrix;
uniform mat3 NormalMatrix;
uniform float time;
uniform vec4 AnimationParams; // tile_width, tile_height, width_num_tiles, height_num_tiles

in vec3 POSITION;
in vec3 NORMAL;
in vec2 TEXCOORD;

out vec2 pos_zw;
out vec3 normal;
out vec3 ec_pos;
out vec4 uv_offset;
out float blend;

vec2 get_tile(in float t)
{
	float tile_index = floor((1.0 - t)*AnimationParams.z*AnimationParams.w);
	float y = floor(tile_index / AnimationParams.z);
	float x = tile_index - y*AnimationParams.z;
	return vec2(x, y) / AnimationParams.zw;
}

void main()
{
	float local_time = mod(time, AnimationParams.z*AnimationParams.w);
	float time_index = local_time / (AnimationParams.z*AnimationParams.w);

	vec2 uv_offs = TEXCOORD;
	uv_offset.xy = uv_offs + get_tile(time_index);
	uv_offset.zw = uv_offs + get_tile( mod(time_index + (1.0/(AnimationParams.z*AnimationParams.w)), 1.0) );
	//uv_offset.zw = uv_offset.xy + AnimationParams.xy;
	blend = smoothstep(0.2, 0.8, mod(local_time, 1.0));
	//blend = 1.0 - mod(local_time, 1.0);

	normal = NormalMatrix * NORMAL;

	ec_pos = vec3(ModelViewMatrix * vec4(POSITION, 1.0));
	vec4 proj_pos = ModelViewProjectionMatrix * vec4(POSITION, 1.0);
	pos_zw = proj_pos.zw;
	gl_Position = proj_pos;
}
