#version 330 core

uniform samplerCube cubemap;

in vec2 pos_zw;
in vec3 normal;
in vec3 uv;

layout (location = 0) out vec4 diffuse_specular;
layout (location = 1) out vec4 normal_depth;


void main()
{
	vec4 diff = texture(cubemap, uv);

	diffuse_specular.rgb = diff.rgb;
	diffuse_specular.a = diff.a;

	normal_depth.rgb = normalize(normal);
	normal_depth.a = pos_zw.x/pos_zw.y;
}
