#version 120
uniform sampler2D tex_blurred;
uniform sampler2D tex_accum;

uniform float refract_ofs;
uniform vec2 res_r;

uniform float exposure;

vec2 calc_tex_coord(vec2 p, float mul){
    return p * vec2(0.5, 0.5) * mul + vec2(0.5, 0.5);
}


void main(){
    vec2 pos = gl_FragCoord.xy * (res_r * 2.0) - vec2(1.0, 1.0);
    // emulate a low quality lens by warping texcoords separately for each color
    vec4 blurred = vec4( texture2D(tex_blurred, calc_tex_coord(pos, 1.0+refract_ofs)).r
                       ,texture2D(tex_blurred, calc_tex_coord(pos, 1.0)).g
                       ,texture2D(tex_blurred, calc_tex_coord(pos, 1.0-refract_ofs)).b
                       ,texture2D(tex_blurred, calc_tex_coord(pos, 1.0)).a);

    vec4 accum = texture2D(tex_accum, pos * vec2(0.5,0.5)+vec2(0.5,0.5));
    // generate a radial gradient to dim the screen's edges
    //vec4 edge_color = vec4(0.0, 0.1, 0.35, 1.0);

    // gamma 2.2
	// screw gamma correction
	//gl_FragColor = pow(accum+blurred, vec4(2.2, 2.2, 2.2, 2.2));
	gl_FragColor = (accum+blurred) * exposure;
}
