/*
 * Decompiled with CFR 0.152.
 */
package vitamin.scenesimple;

import vitamin.math.IntersectionPoint;
import vitamin.math.Vector3;
import vitamin.scenesimple.BoundingBox;
import vitamin.scenesimple.Mesh;
import vitamin.scenesimple.Vertex;

public class BoundingSphere {
    public float _radius;
    public float _radiusSquared;
    public Vector3 _center;

    public BoundingSphere() {
        this._radius = 1.0f;
        this._center = new Vector3();
    }

    public BoundingSphere(BoundingSphere bs) {
        this._radius = bs._radius;
        this._radiusSquared = this._radius * this._radius;
        this._center = bs._center;
    }

    public BoundingSphere clone() {
        BoundingSphere b = new BoundingSphere();
        b._radius = this._radius;
        b._radiusSquared = this._radius * this._radius;
        b._center = this._center.clone();
        return b;
    }

    public void calculate(Mesh m) {
        int numOfPoints = m.getVertexCount();
        float distance = 0.0f;
        float tempDist = 0.0f;
        int i = 0;
        while (i < numOfPoints) {
            Vertex v = m.getVertexList().get(i);
            tempDist = (v.getPosition().x - this._center.x) * (v.getPosition().x - this._center.x) + (v.getPosition().y - this._center.y) * (v.getPosition().y - this._center.y) + (v.getPosition().z - this._center.z) * (v.getPosition().z - this._center.z);
            if (tempDist > distance) {
                distance = tempDist;
            }
            ++i;
        }
        this._radius = (float)Math.sqrt(distance);
        this._radiusSquared = this._radius * this._radius;
    }

    public void translate(Vector3 v) {
        this._center.add(v);
    }

    public boolean collisionCheck(BoundingSphere bs) {
        Vector3 vec = Vector3.sub(this._center, bs._center);
        return Math.sqrt(Vector3.dot(vec, vec)) < (double)(this._radius + bs._radius);
    }

    public boolean collisionCheck(Vector3 p1) {
        Vector3 vec = Vector3.sub(this._center, p1);
        return Math.sqrt(Vector3.dot(vec, vec)) < (double)(this._radius + 0.01f);
    }

    public boolean collisionCheck(Vector3 p1, Vector3 p2, Vector3 p3) {
        if (this.collisionCheck(p1)) {
            return true;
        }
        if (this.collisionCheck(p2)) {
            return true;
        }
        return this.collisionCheck(p3);
    }

    public boolean collisionCheck(BoundingBox aabb) {
        Vector3 b = new Vector3(aabb._min.x, aabb._max.y, aabb._min.z);
        Vector3 c = new Vector3(aabb._max.x, aabb._max.y, aabb._min.z);
        Vector3 d = new Vector3(aabb._max.x, aabb._min.y, aabb._min.z);
        Vector3 e = new Vector3(aabb._min.x, aabb._min.y, aabb._max.z);
        Vector3 f = new Vector3(aabb._min.x, aabb._max.y, aabb._max.z);
        Vector3 h = new Vector3(aabb._max.x, aabb._min.y, aabb._max.z);
        if (this.collisionCheck(aabb._min)) {
            return true;
        }
        if (this.collisionCheck(b)) {
            return true;
        }
        if (this.collisionCheck(c)) {
            return true;
        }
        if (this.collisionCheck(d)) {
            return true;
        }
        if (this.collisionCheck(e)) {
            return true;
        }
        if (this.collisionCheck(f)) {
            return true;
        }
        if (this.collisionCheck(aabb._max)) {
            return true;
        }
        return this.collisionCheck(h);
    }

    public int intersectRay(Vector3 rayStart, Vector3 rayDirection, IntersectionPoint intPt0, IntersectionPoint intPt1) {
        Vector3 tempDiff;
        float c;
        float a = rayDirection.lengthSquared();
        if ((double)a == 0.0) {
            return 0;
        }
        float b = 2.0f * (rayStart.dot(rayDirection) - rayDirection.dot(this._center));
        float disc = b * b - 4.0f * a * (c = (tempDiff = Vector3.sub(this._center, rayStart)).lengthSquared() - this._radiusSquared);
        if (disc < 0.0f) {
            return 0;
        }
        int numIntersections = disc == 0.0f ? 1 : 2;
        intPt0._t = 0.5f * (-1.0f * b + (float)Math.sqrt(disc)) / a;
        if (numIntersections == 2) {
            intPt1._t = 0.5f * (-1.0f * b - (float)Math.sqrt(disc)) / a;
        }
        Vector3 tmp = new Vector3(rayDirection);
        tmp.mul(intPt0._t);
        tmp.add(rayStart);
        intPt0._pos = tmp;
        if (numIntersections == 2) {
            tmp.set(rayDirection);
            tmp.mul(intPt1._t);
            tmp.add(rayStart);
            intPt1._pos = tmp;
        }
        return numIntersections;
    }
}

