/*
 * Decompiled with CFR 0.152.
 */
package vitamin.math;

import java.util.Random;
import vitamin.math.Vector3;

public class MathUtils {
    public static float crude_pow_awesome_guess(float nbase, float exponent) {
        exponent *= exponent;
        float denom = exponent * nbase;
        denom = exponent - denom + nbase;
        return nbase / denom;
    }

    public static float fsel(float a, float b, float c) {
        return a >= 0.0f ? b : c;
    }

    public static boolean fuzzyZero(float x) {
        return Math.abs(x) < 1.1920929E-7f;
    }

    public static float atan2Fast(float y, float x) {
        float angle;
        float coeff_1 = 0.7853982f;
        float coeff_2 = 3.0f * coeff_1;
        float abs_y = Math.abs(y);
        if (x >= 0.0f) {
            float r = (x - abs_y) / (x + abs_y);
            angle = coeff_1 - coeff_1 * r;
        } else {
            float r = (x + abs_y) / (abs_y - x);
            angle = coeff_2 - coeff_1 * r;
        }
        return y < 0.0f ? -angle : angle;
    }

    public static float bias(float value, float b) {
        return b > 0.0f ? (float)Math.pow(value, Math.log(b) / Math.log(0.5)) : 0.0f;
    }

    public static float gain(float value, float g) {
        return 0.5f * ((double)value < 0.5 ? MathUtils.bias(2.0f * value, 1.0f - g) : 2.0f - MathUtils.bias(2.0f - 2.0f * value, 1.0f - g));
    }

    public static float bilerp(float a, float b, float c, float d, float u, float v) {
        return a * ((1.0f - u) * (1.0f - v)) + b * (u * (1.0f - v)) + c * (v * (1.0f - u)) + d * (u * v);
    }

    public static float smoothstep(float a, float b, float x) {
        if (x < a) {
            return 0.0f;
        }
        if (x >= b) {
            return 1.0f;
        }
        x = (x - a) / (b - a);
        return x * x * (3.0f - 2.0f * x);
    }

    public static float[] sphericalToCartesian(float rho, float phi, float theta) {
        float x = rho * (float)Math.cos(phi) * (float)Math.cos(theta);
        float y = rho * (float)Math.sin(phi);
        float z = rho * (float)Math.cos(phi) * (float)Math.sin(theta);
        return new float[]{x, y, z};
    }

    public static float[] cartesionToSpherical(float x, float y, float z) {
        float r = (float)Math.sqrt(x * x + y * y + z * z);
        float phi = (float)Math.acos(z / r);
        float theta = (float)Math.atan2(y, x);
        return new float[]{r, phi, theta};
    }

    public static final float degrees(float radians) {
        return radians * 57.295776f;
    }

    public static final float radians(float degrees) {
        return degrees * ((float)Math.PI / 180);
    }

    public static final float map(float value, float istart, float istop, float ostart, float ostop) {
        return ostart + (ostop - ostart) * ((value - istart) / (istop - istart));
    }

    public static float clamp(float val, float min, float max) {
        if (val < min) {
            return min;
        }
        if (val > max) {
            return max;
        }
        return val;
    }

    public static int clamp(int val, int min, int max) {
        if (val < min) {
            return min;
        }
        if (val > max) {
            return max;
        }
        return val;
    }

    public static int sgn(float f) {
        if (f > 0.0f) {
            return 1;
        }
        if (f < 0.0f) {
            return -1;
        }
        return 0;
    }

    public static final float random(int v) {
        return (float)Math.random() * (float)v;
    }

    public static final float random(int min, int max) {
        return (float)((double)min + Math.random() * (double)(max - min));
    }

    public static final float random(float v) {
        return (float)Math.random() * v;
    }

    public static final float random(float min, float max) {
        return (float)((double)min + Math.random() * (double)(max - min));
    }

    public static final float random(double v) {
        return (float)(Math.random() * v);
    }

    public static final float random(double min, double max) {
        return (float)(min + Math.random() * (max - min));
    }

    public static final float normalizedRandom() {
        return (float)Math.random() * 2.0f - 1.0f;
    }

    public static final float normalizedRandom(Random rnd) {
        return rnd.nextFloat() * 2.0f - 1.0f;
    }

    public static boolean makePerpendicular(Vector3 src, Vector3 dest) {
        if (src.x == 0.0f && src.y == 0.0f && src.z == 0.0f) {
            return false;
        }
        if (src.x != 0.0f) {
            if (src.y != 0.0f) {
                dest.set(-src.y, src.x, 0.0f);
            } else {
                dest.set(-src.z, 0.0f, src.x);
            }
        } else {
            dest.set(1.0f, 0.0f, 0.0f);
        }
        return true;
    }

    Vector3 makePerpendicular(Vector3 direction) {
        Vector3 i = new Vector3(1.0f, 0.0f, 0.0f);
        Vector3 j = new Vector3(0.0f, 1.0f, 0.0f);
        Vector3 k = new Vector3(0.0f, 0.0f, 1.0f);
        float id = i.dot(direction);
        float jd = j.dot(direction);
        float kd = k.dot(direction);
        Vector3 quasiPerp = id <= jd && id <= kd ? i : (jd <= id && jd <= kd ? j : k);
        Vector3 result = Vector3.cross(direction, quasiPerp);
        return result;
    }
}

