/*
 * Decompiled with CFR 0.152.
 */
package vitamin.interpolation;

import vitamin.interpolation.Interpolator;

public class Smoothstep
implements Interpolator {
    public static float easeIn(float t, float b, float c, float d) {
        if (t > d) {
            return c;
        }
        float v = t / d;
        float tt = v * v;
        return b + (c - b) * Smoothstep.SMOOTHSTEP(tt);
    }

    public static float easeOut(float t, float b, float c, float d) {
        if (t > d) {
            return c;
        }
        float v = t / d;
        float tt = 1.0f - (1.0f - v) * (1.0f - v);
        return b + (c - b) * Smoothstep.SMOOTHSTEP(tt);
    }

    public static float easeInOut(float t, float b, float c, float d) {
        if (t > d) {
            return c;
        }
        return b + (c - b) * Smoothstep.SMOOTHSTEP(t / d);
    }

    private static float SMOOTHSTEP(double x) {
        return (float)(x * x * (3.0 - 2.0 * x));
    }
}

