/*
 * Decompiled with CFR 0.152.
 */
package vitamin;

import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import javax.media.opengl.GL;
import javax.media.opengl.GLException;
import vitamin.VImage;
import vitamin.VSamplerState;

public class VTexture {
    public static final int TEXTURE_1D = 0;
    public static final int TEXTURE_2D = 1;
    public static final int TEXTURE_RECTANGLE_2D = 2;
    public static final int TEXTURE_3D = 3;
    public static final int TEXTURE_CUBE_MAP = 4;
    public static int[] GLInternalFormats;
    public static int[] GLFormats;
    public static int[] GLDataTypes;
    public int _textureType;
    public String _name;
    String _fileName;
    public int _id;
    public int _targetID;
    VSamplerState _samplerState;
    int _format;
    int _width;
    int _height;
    int _depth;
    int _bpp;
    GL _gl;

    static {
        int[] nArray = new int[25];
        nArray[1] = 6409;
        nArray[2] = 6410;
        nArray[3] = 6407;
        nArray[4] = 32849;
        nArray[5] = 6408;
        nArray[6] = 32856;
        nArray[7] = 36233;
        nArray[8] = 36232;
        nArray[9] = 36227;
        nArray[10] = 36226;
        nArray[11] = 34837;
        nArray[12] = 34836;
        nArray[13] = 6402;
        nArray[14] = 33189;
        nArray[15] = 33190;
        nArray[16] = 35056;
        nArray[17] = 6407;
        nArray[18] = 6408;
        nArray[19] = 34840;
        nArray[20] = 34846;
        nArray[21] = 34843;
        nArray[22] = 34842;
        nArray[23] = 32857;
        nArray[24] = 36268;
        GLInternalFormats = nArray;
        int[] nArray2 = new int[25];
        nArray2[1] = 6408;
        nArray2[2] = 6408;
        nArray2[3] = 32993;
        nArray2[4] = 6408;
        nArray2[5] = 32993;
        nArray2[6] = 32993;
        nArray2[7] = 6407;
        nArray2[8] = 6408;
        nArray2[9] = 6407;
        nArray2[10] = 6408;
        nArray2[11] = 6407;
        nArray2[12] = 6408;
        nArray2[13] = 6402;
        nArray2[14] = 6402;
        nArray2[15] = 6402;
        nArray2[16] = 6402;
        nArray2[17] = 32993;
        nArray2[18] = 32993;
        nArray2[19] = 6409;
        nArray2[20] = 6409;
        nArray2[21] = 6407;
        nArray2[22] = 6408;
        nArray2[23] = 6408;
        nArray2[24] = 6402;
        GLFormats = nArray2;
        int[] nArray3 = new int[25];
        nArray3[1] = 5121;
        nArray3[2] = 5121;
        nArray3[3] = 5121;
        nArray3[4] = 5121;
        nArray3[5] = 5121;
        nArray3[6] = 5121;
        nArray3[7] = 5123;
        nArray3[8] = 5123;
        nArray3[9] = 5125;
        nArray3[10] = 5125;
        nArray3[11] = 5126;
        nArray3[12] = 5126;
        nArray3[13] = 5125;
        nArray3[14] = 5123;
        nArray3[15] = 5125;
        nArray3[16] = 34042;
        nArray3[17] = 5121;
        nArray3[18] = 5121;
        nArray3[19] = 5126;
        nArray3[20] = 5131;
        nArray3[21] = 5131;
        nArray3[22] = 5131;
        nArray3[23] = 5131;
        nArray3[24] = 5126;
        GLDataTypes = nArray3;
    }

    public VTexture(GL gl) {
        this._gl = gl;
        this._name = null;
        this._id = 0;
        this._targetID = 3553;
        this._textureType = 1;
    }

    public VTexture(GL gl, int targetID) {
        this._gl = gl;
        this._name = null;
        this._id = 0;
        this._targetID = targetID;
        switch (targetID) {
            case 3552: {
                this._textureType = 1;
                break;
            }
            case 3553: {
                this._textureType = 1;
                break;
            }
            case 34037: {
                this._textureType = 2;
                break;
            }
            case 32879: {
                this._textureType = 3;
                break;
            }
            case 34067: {
                this._textureType = 4;
                break;
            }
            case 36161: {
                this._textureType = 36161;
                break;
            }
            default: {
                System.err.println("Invalid texture target");
            }
        }
    }

    public VTexture(GL gl, int targetID, String filename) {
        this._gl = gl;
        this._name = filename;
        this._id = 0;
        this._targetID = targetID;
        switch (targetID) {
            case 3552: {
                this._textureType = 1;
                break;
            }
            case 3553: {
                this._textureType = 1;
                break;
            }
            case 34037: {
                this._textureType = 2;
                break;
            }
            case 32879: {
                this._textureType = 3;
                break;
            }
            case 34067: {
                this._textureType = 4;
                break;
            }
            case 36161: {
                this._textureType = 36161;
                break;
            }
            default: {
                System.err.println("Invalid texture target");
            }
        }
        this.loadFromFile(filename, true);
    }

    public void release() {
        int[] texId = new int[]{this._id};
        try {
            if (this._targetID == 36161) {
                this._gl.glDeleteRenderbuffersEXT(1, texId, 0);
            } else {
                this._gl.glDeleteTextures(1, texId, 0);
            }
        }
        catch (GLException e) {
            System.err.println("(VTexture)  " + (Object)((Object)e));
        }
    }

    public void enable() {
        this._gl.glEnable(this._targetID);
        this._gl.glBindTexture(this._targetID, this._id);
    }

    public void enable(int textureBank) {
        this.switchTextureBank(textureBank);
        this._gl.glEnable(this._targetID);
        this._gl.glBindTexture(this._targetID, this._id);
    }

    public void disable() {
        this._gl.glDisable(this._targetID);
        this._gl.glBindTexture(this._targetID, 0);
    }

    public void disable(int textureBank) {
        this.switchTextureBank(textureBank);
        this._gl.glDisable(this._targetID);
        this._gl.glBindTexture(this._targetID, 0);
    }

    public void bind() {
        this._gl.glEnable(this._targetID);
        this._gl.glBindTexture(this._targetID, this._id);
    }

    public void bind(int textureBank) {
        this.switchTextureBank(textureBank);
        this._gl.glEnable(this._targetID);
        this._gl.glBindTexture(this._targetID, this._id);
    }

    public void unbind() {
        this._gl.glDisable(this._targetID);
        this._gl.glBindTexture(this._targetID, 0);
    }

    public void unbind(int textureBank) {
        this.switchTextureBank(textureBank);
        this._gl.glDisable(this._targetID);
        this._gl.glBindTexture(this._targetID, 0);
    }

    public void switchTextureBank(int i) {
        switch (i) {
            case 0: {
                this._gl.glActiveTexture(33984);
                break;
            }
            case 1: {
                this._gl.glActiveTexture(33985);
                break;
            }
            case 2: {
                this._gl.glActiveTexture(33986);
                break;
            }
            case 3: {
                this._gl.glActiveTexture(33987);
                break;
            }
            case 4: {
                this._gl.glActiveTexture(33988);
                break;
            }
            case 5: {
                this._gl.glActiveTexture(33989);
                break;
            }
            case 6: {
                this._gl.glActiveTexture(33990);
                break;
            }
            case 7: {
                this._gl.glActiveTexture(33991);
            }
        }
    }

    public void create(int width, int height, int surfaceFormat) {
        this.setSamplerState(10497, 10497, 9729, 9729, 16);
        this.create(this._targetID, width, height, surfaceFormat, this._samplerState);
    }

    public void create(int target, int width, int height, int surfaceFormat, VSamplerState samp) {
        switch (target) {
            case 3552: {
                this._targetID = 3552;
                break;
            }
            case 3553: {
                this._targetID = 3553;
                break;
            }
            case 34037: {
                this._targetID = 34037;
                break;
            }
            case 32879: {
                System.err.println("(VTexture)  Use createTexture3D to create a 3D texture.");
                return;
            }
            case 34067: {
                System.err.println("(VTexture)  Use VTextureCUBE to create a CubeMap.");
                return;
            }
            default: {
                System.err.println("(VTexture)  You have to specify a valid target.");
                return;
            }
        }
        this._width = width;
        this._height = height;
        this._depth = -1;
        this._format = surfaceFormat;
        int srcType = GLDataTypes[surfaceFormat];
        int internalFormat = GLInternalFormats[surfaceFormat];
        int srcFormat = GLFormats[surfaceFormat];
        if (samp != null) {
            this.setSamplerState(samp);
        } else {
            this.setSamplerState(10497, 10497, 9729, 9729, 16);
        }
        int[] id = new int[1];
        this._gl.glGenTextures(1, id, 0);
        this._id = id[0];
        this._gl.glBindTexture(this._targetID, this._id);
        this._gl.glTexParameteri(this._targetID, 10242, this._samplerState._wrapS);
        this._gl.glTexParameteri(this._targetID, 10243, this._samplerState._wrapT);
        this._gl.glTexParameteri(this._targetID, 10241, this._samplerState._minFilter);
        this._gl.glTexParameteri(this._targetID, 10240, this._samplerState._magFilter);
        this._gl.glTexImage2D(this._targetID, 0, internalFormat, this._width, this._height, 0, srcFormat, srcType, null);
    }

    public void createData(int target, int width, int height, int[] data, int surfaceFormat, VSamplerState samp) {
        switch (target) {
            case 3552: {
                this._targetID = 3552;
                break;
            }
            case 3553: {
                this._targetID = 3553;
                break;
            }
            case 34037: {
                this._targetID = 34037;
                break;
            }
            case 32879: 
            case 34067: {
                System.err.println("(VTexture)  This method does not work for 3D or Cubemap textures.");
                return;
            }
            default: {
                System.err.println("(VTexture)  You have to specify a valid target.");
                return;
            }
        }
        this._width = width;
        this._height = height;
        this._depth = -1;
        this._format = surfaceFormat;
        int srcType = GLDataTypes[surfaceFormat];
        int internalFormat = GLInternalFormats[surfaceFormat];
        int srcFormat = GLFormats[surfaceFormat];
        if (samp != null) {
            this.setSamplerState(samp);
        } else {
            this.setSamplerState(10497, 10497, 9729, 9729, 16);
        }
        int[] id = new int[1];
        this._gl.glGenTextures(1, id, 0);
        this._id = id[0];
        this._gl.glBindTexture(this._targetID, this._id);
        this._gl.glTexParameteri(this._targetID, 10242, this._samplerState._wrapS);
        this._gl.glTexParameteri(this._targetID, 10243, this._samplerState._wrapT);
        this._gl.glTexParameteri(this._targetID, 10241, this._samplerState._minFilter);
        this._gl.glTexParameteri(this._targetID, 10240, this._samplerState._magFilter);
        this._gl.glTexImage2D(this._targetID, 0, internalFormat, this._width, this._height, 0, srcFormat, srcType, (Buffer)IntBuffer.wrap(data));
    }

    public void createTexture3D(int target, int width, int height, int depth, int surfaceFormat, VSamplerState samp) {
        switch (target) {
            case 3552: 
            case 3553: 
            case 34037: 
            case 34067: {
                System.err.println("(VTexture)  This method only works for 3D textures.");
                return;
            }
            case 32879: {
                this._targetID = 32879;
                break;
            }
            default: {
                System.err.println("(VTexture)  You have to specify a valid target.");
                return;
            }
        }
        this._width = width;
        this._height = height;
        this._format = surfaceFormat;
        int srcType = GLDataTypes[surfaceFormat];
        int internalFormat = GLInternalFormats[surfaceFormat];
        int srcFormat = GLFormats[surfaceFormat];
        if (samp != null) {
            this.setSamplerState(samp);
        } else {
            this.setSamplerState(10497, 10497, 10497, 9987, 9729, 16);
        }
        int[] id = new int[1];
        this._gl.glGenTextures(1, id, 0);
        this._id = id[0];
        this._gl.glBindTexture(this._targetID, this._id);
        this._gl.glTexParameteri(this._targetID, 10242, this._samplerState._wrapS);
        this._gl.glTexParameteri(this._targetID, 10243, this._samplerState._wrapT);
        this._gl.glTexParameteri(this._targetID, 32882, this._samplerState._wrapR);
        this._gl.glTexParameteri(this._targetID, 10241, this._samplerState._minFilter);
        this._gl.glTexParameteri(this._targetID, 10240, this._samplerState._magFilter);
        this._gl.glTexImage3D(this._targetID, 0, internalFormat, this._width, this._height, this._depth, 0, srcFormat, srcType, null);
    }

    public void createDepthRT(int width, int height, int surfaceFormat) {
        if (this._id > 0) {
            System.err.println("This texture has already been set. Not possible to create Depth Target");
            return;
        }
        this._targetID = 36161;
        this._width = width;
        this._height = height;
        this._format = surfaceFormat;
        int internalFormat = GLInternalFormats[surfaceFormat];
        int[] id = new int[1];
        this._gl.glGenRenderbuffersEXT(1, id, 0);
        this._id = id[0];
        this._gl.glBindRenderbufferEXT(36161, this._id);
        this._gl.glRenderbufferStorageEXT(36161, internalFormat, this._width, this._height);
        this._gl.glBindRenderbufferEXT(36161, 0);
    }

    public boolean loadFromImage(VImage img, boolean mipmap) {
        return this.loadFromImage(img, mipmap, null);
    }

    public boolean loadFromImage(VImage img, boolean mipmap, VSamplerState samp) {
        if (img == null) {
            return false;
        }
        boolean isLoaded = false;
        this._fileName = null;
        this._width = img.getWidth();
        this._height = img.getHeight();
        switch (img.getFormat()) {
            case 0: {
                this._format = 1;
                break;
            }
            case 7: {
                this._format = 2;
                break;
            }
            case 4: {
                this._format = 1;
                break;
            }
            case 1: {
                this._format = 3;
                break;
            }
            case 2: {
                this._format = 5;
                break;
            }
            case 3: {
                this._format = 18;
                break;
            }
            case 5: {
                this._format = 17;
                break;
            }
            case 6: {
                this._format = 18;
                break;
            }
            default: {
                this._format = 18;
            }
        }
        int internalFormat = GLInternalFormats[this._format];
        int srcFormat = GLFormats[this._format];
        int srcType = GLDataTypes[this._format];
        System.out.println("(VTexture) Texture Info: " + this._width + ", " + this._height + ",  Format: " + this._format);
        if (samp != null) {
            this.setSamplerState(samp);
        } else if (mipmap) {
            this.setSamplerState(10497, 10497, 10497, 9987, 9729, 16);
        } else {
            this.setSamplerState(10497, 10497, 10497, 9729, 9729, 16);
        }
        int[] id = new int[1];
        this._gl.glGenTextures(1, id, 0);
        this._id = id[0];
        this._gl.glBindTexture(this._targetID, this._id);
        this._gl.glTexParameterf(this._targetID, 10242, (float)this._samplerState._wrapS);
        this._gl.glTexParameterf(this._targetID, 10243, (float)this._samplerState._wrapT);
        this._gl.glTexParameterf(this._targetID, 10241, (float)this._samplerState._minFilter);
        this._gl.glTexParameterf(this._targetID, 10240, (float)this._samplerState._magFilter);
        if (mipmap) {
            this._gl.glTexParameterf(this._targetID, 33169, 1.0f);
            this._gl.glGenerateMipmapEXT(this._targetID);
        } else {
            this._gl.glTexParameterf(this._targetID, 33169, 0.0f);
        }
        switch (this._targetID) {
            case 3552: {
                this._gl.glTexImage1D(this._targetID, 0, internalFormat, this._width, 0, srcFormat, srcType, (Buffer)IntBuffer.wrap(img.getData()));
                break;
            }
            case 3553: {
                this._gl.glTexImage2D(this._targetID, 0, internalFormat, this._width, this._height, 0, srcFormat, srcType, (Buffer)IntBuffer.wrap(img.getData()));
                break;
            }
            case 34037: {
                this._gl.glTexImage2D(this._targetID, 0, internalFormat, this._width, this._height, 0, srcFormat, srcType, (Buffer)IntBuffer.wrap(img.getData()));
                break;
            }
            default: {
                this._gl.glTexImage2D(this._targetID, 0, internalFormat, this._width, this._height, 0, srcFormat, srcType, (Buffer)IntBuffer.wrap(img.getData()));
            }
        }
        isLoaded = true;
        System.out.println("(VTexture) VImage Texture loaded with id: " + this._id);
        return isLoaded;
    }

    public boolean loadFromFile(String filename, boolean mipmap) {
        return this.loadFromFile(filename, mipmap, null);
    }

    public boolean loadFromFile(String filename, boolean mipmap, VSamplerState samp) {
        boolean isLoaded = false;
        this._fileName = filename;
        VImage img = new VImage();
        if (!img.loadFromFile(this._fileName)) {
            System.err.println("(VTexture)  Failed to load imagefile: " + filename);
            return false;
        }
        System.out.println("(VTexture)  ** Loading texture: " + filename);
        this._width = img.getWidth();
        this._height = img.getHeight();
        switch (img.getFormat()) {
            case 0: {
                this._format = 1;
                break;
            }
            case 4: {
                this._format = 1;
                break;
            }
            case 1: {
                this._format = 3;
                break;
            }
            case 2: {
                this._format = 5;
                break;
            }
            case 3: {
                this._format = 5;
                break;
            }
            case 5: {
                this._format = 17;
                break;
            }
            case 6: {
                this._format = 18;
                break;
            }
            default: {
                this._format = 18;
            }
        }
        int internalFormat = GLInternalFormats[this._format];
        int srcFormat = GLFormats[this._format];
        int srcType = GLDataTypes[this._format];
        System.out.println("(VTexture) Texture Info: " + this._width + ", " + this._height + ",  Format: " + this._format);
        if (samp != null) {
            this.setSamplerState(samp);
        } else if (mipmap) {
            this.setSamplerState(10497, 10497, 10497, 9987, 9729, 16);
        } else {
            this.setSamplerState(10497, 10497, 10497, 9729, 9729, 16);
        }
        int[] id = new int[1];
        this._gl.glGenTextures(1, id, 0);
        this._id = id[0];
        if (this._id <= 0) {
            System.err.println("(VTexture)  Couldn't create opengl texture id");
            return false;
        }
        this._gl.glBindTexture(this._targetID, this._id);
        this._gl.glTexParameterf(this._targetID, 10242, (float)this._samplerState._wrapS);
        this._gl.glTexParameterf(this._targetID, 10243, (float)this._samplerState._wrapT);
        this._gl.glTexParameterf(this._targetID, 10241, (float)this._samplerState._minFilter);
        this._gl.glTexParameterf(this._targetID, 10240, (float)this._samplerState._magFilter);
        if (mipmap) {
            this._gl.glTexParameterf(this._targetID, 33169, 1.0f);
            this._gl.glGenerateMipmapEXT(this._targetID);
        } else {
            this._gl.glTexParameterf(this._targetID, 33169, 0.0f);
        }
        switch (this._targetID) {
            case 3552: {
                this._gl.glTexImage1D(this._targetID, 0, internalFormat, this._width, 0, srcFormat, srcType, (Buffer)IntBuffer.wrap(img.getData()));
                break;
            }
            case 3553: {
                this._gl.glTexImage2D(this._targetID, 0, internalFormat, this._width, this._height, 0, srcFormat, srcType, (Buffer)IntBuffer.wrap(img.getData()));
                break;
            }
            case 34037: {
                this._gl.glTexImage2D(this._targetID, 0, internalFormat, this._width, this._height, 0, srcFormat, srcType, (Buffer)IntBuffer.wrap(img.getData()));
                break;
            }
            default: {
                this._gl.glTexImage2D(this._targetID, 0, internalFormat, this._width, this._height, 0, srcFormat, srcType, (Buffer)IntBuffer.wrap(img.getData()));
            }
        }
        isLoaded = true;
        img = null;
        this._gl.glBindTexture(this._targetID, 0);
        System.out.println("(VTexture) Texture '" + filename + "' loaded with id: " + this._id);
        return isLoaded;
    }

    public void grabBuffer() {
        this.grabBuffer(0, 0, 0, 0);
    }

    public void grabBuffer(int x0, int y0, int x1, int y1) {
        if (this._targetID != 3553 && this._targetID != 34037) {
            System.err.println("(VTexture)  Can't update texture. this texture target is not supported");
            return;
        }
        this._gl.glBindTexture(this._targetID, this._id);
        this._gl.glCopyTexSubImage2D(this._targetID, 0, x0, y0, 0, 0, this._width - 2 * x1, this._height - 2 * y1);
        this._gl.glBindTexture(this._targetID, 0);
    }

    public void update(int[] pixels) {
        if (this._targetID != 3553 && this._targetID != 34037) {
            System.err.println("(VTexture)  Can't update texture. Current gltarget is not GL_TEXTURE_2D or GL_TEXTURE_RECTANGLE_ARB.");
            return;
        }
        int srcFormat = GLFormats[this._format];
        int srcType = GLDataTypes[this._format];
        this._gl.glBindTexture(this._targetID, this._id);
        this._gl.glPixelStorei(3317, 1);
        this._gl.glTexSubImage2D(this._targetID, 0, 0, 0, this._width, this._height, srcFormat, srcType, (Buffer)IntBuffer.wrap(pixels));
        this._gl.glBindTexture(this._targetID, 0);
    }

    public void update(float[] pixels) {
        if (this._targetID != 3553 && this._targetID != 34037) {
            System.err.println("(VTexture)  Can't update texture. Current gltarget is not GL_TEXTURE_2D or GL_TEXTURE_RECTANGLE_ARB.");
            return;
        }
        int srcFormat = GLFormats[this._format];
        int srcType = GLDataTypes[this._format];
        this._gl.glBindTexture(this._targetID, this._id);
        this._gl.glPixelStorei(3317, 1);
        this._gl.glTexSubImage2D(this._targetID, 0, 0, 0, this._width, this._height, srcFormat, srcType, (Buffer)FloatBuffer.wrap(pixels));
        this._gl.glBindTexture(this._targetID, 0);
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    public void setSamplerState(VSamplerState s) {
        this._samplerState = new VSamplerState();
        this._samplerState._anisotropy = s._anisotropy;
        this._samplerState._lod = s._lod;
        this._samplerState._magFilter = s._magFilter;
        this._samplerState._minFilter = s._minFilter;
        this._samplerState._wrapR = s._wrapR;
        this._samplerState._wrapS = s._wrapS;
        this._samplerState._wrapT = s._wrapT;
    }

    public void setSamplerState(int wrapS, int wrapT, int minFilter, int magFilter, int aniso) {
        this._samplerState = new VSamplerState();
        this._samplerState._anisotropy = aniso;
        this._samplerState._lod = 1.0f;
        this._samplerState._magFilter = magFilter;
        this._samplerState._minFilter = minFilter;
        this._samplerState._wrapR = 9729;
        this._samplerState._wrapS = wrapS;
        this._samplerState._wrapT = wrapT;
    }

    public void setSamplerState(int wrapS, int wrapT, int wrapR, int minFilter, int magFilter, int aniso) {
        this._samplerState = new VSamplerState();
        this._samplerState._anisotropy = aniso;
        this._samplerState._lod = 1.0f;
        this._samplerState._magFilter = magFilter;
        this._samplerState._minFilter = minFilter;
        this._samplerState._wrapR = wrapS;
        this._samplerState._wrapS = wrapS;
        this._samplerState._wrapT = wrapT;
    }

    public int getTarget() {
        return this._targetID;
    }

    public int getId() {
        return this._id;
    }

    public int id() {
        return this._id;
    }

    public int getID() {
        return this._id;
    }

    public int getWidth() {
        return this._width;
    }

    public int getHeight() {
        return this._height;
    }

    public int width() {
        return this._width;
    }

    public int height() {
        return this._height;
    }

    public int getFormat() {
        return this._format;
    }

    public int getBitDepth() {
        switch (this._format) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 3;
            }
            case 5: {
                return 4;
            }
            case 6: {
                return 4;
            }
            case 7: {
                return 3;
            }
            case 8: {
                return 4;
            }
            case 9: {
                return 3;
            }
            case 10: {
                return 4;
            }
            case 11: {
                return 3;
            }
            case 12: {
                return 4;
            }
            case 13: {
                return 2;
            }
            case 14: {
                return 2;
            }
            case 15: {
                return 3;
            }
            case 16: {
                return 4;
            }
            case 17: {
                return 3;
            }
            case 18: {
                return 4;
            }
            case 19: {
                return 4;
            }
            case 20: {
                return 2;
            }
            case 21: {
                return 2;
            }
            case 22: {
                return 2;
            }
            case 23: {
                return 4;
            }
            case 24: {
                return 4;
            }
        }
        return 0;
    }
}

