/*
 * Decompiled with CFR 0.152.
 */
package vitamin;

public class VTimer {
    public static int REALTIME = 0;
    public static int OFFLINE = 1;
    private int _type;
    private int _currFrame;
    private long _sTime;
    private long _cTime;
    private float _frameTime;
    private float _lastCurrTime;
    private float _currTime;
    private float _frameRateCount;
    private float _frameRate;
    private float _frameRateTime;
    private float _frameResetTime;

    public VTimer() {
        this._type = REALTIME;
        this._currTime = 0.0f;
        this._currFrame = 0;
        this._frameTime = 0.0f;
        this._frameRate = 0.0f;
        this._frameRateTime = 0.0f;
        this._frameResetTime = 0.0f;
    }

    public VTimer(int type) {
        this._type = type;
        if (this._type == REALTIME) {
            this._currTime = 0.0f;
            this._currFrame = 0;
            this._frameTime = 0.0f;
            this._frameRate = 0.0f;
            this._frameRateTime = 0.0f;
            this._frameResetTime = 0.0f;
        } else if (this._type == OFFLINE) {
            this._currTime = 0.0f;
            this._currFrame = 0;
            this._frameTime = 0.033333335f;
            this._sTime = 0L;
            this._frameRate = 30.0f;
            this._frameRateTime = 0.0f;
            this._frameResetTime = 0.0f;
        } else {
            System.err.println("(VTimer) This timer type is not supported. Pleae choose REALTIME or OFFLINE type");
        }
    }

    public VTimer(int type, int frameRate) {
        this._type = type;
        if (this._type == REALTIME) {
            this._currTime = 0.0f;
            this._currFrame = 0;
            this._frameTime = 0.0f;
            this._frameRate = 0.0f;
            this._frameRateTime = 0.0f;
            this._frameResetTime = 0.0f;
        } else if (this._type == OFFLINE) {
            this._currTime = 0.0f;
            this._currFrame = 0;
            this._frameTime = 1.0f / (float)frameRate;
            this._sTime = 0L;
            this._frameRate = frameRate;
            this._frameRateTime = 0.0f;
            this._frameResetTime = 0.0f;
        } else {
            System.err.println("(VTimer) This timer type is not supported. Pleae choose REALTIME or OFFLINE type");
        }
    }

    public long getTimeMilliseconds() {
        return System.nanoTime() / 1000000L;
    }

    public long getTimeMicroseconds() {
        return System.nanoTime() / 1000L;
    }

    public float millis() {
        this._cTime = this._type == REALTIME ? this.getTimeMilliseconds() : (long)((float)this._cTime + this._frameTime);
        return this._cTime;
    }

    public void start() {
        if (this._type == REALTIME) {
            this._sTime = this.getTimeMilliseconds();
            this._frameTime = 0.0f;
            this._frameRateTime = 0.0f;
            this._frameResetTime = 0.0f;
            this._frameRate = 0.0f;
            this._frameRateCount = 0.0f;
        }
    }

    public void update() {
        if (this._type == REALTIME) {
            this._lastCurrTime = this._currTime;
            this._cTime = this.getTimeMilliseconds();
            this._currTime = (float)(this._cTime - this._sTime) * 0.001f;
            ++this._currFrame;
            this._frameTime = this._currTime - this._lastCurrTime;
            this._frameRateCount += 1.0f;
            this._frameRateTime = this._currTime - this._frameResetTime;
            if (this._frameRateTime >= 1.0f) {
                this._frameRate = this._frameRateCount;
                this._frameResetTime = this._currTime;
                this._frameRateCount = 0.0f;
            }
        } else {
            this._currTime += this._frameTime;
            ++this._currFrame;
        }
    }

    public void reset() {
        if (this._type == REALTIME) {
            this._cTime = this._sTime = this.getTimeMilliseconds();
            this._currTime = (float)(this._cTime - this._sTime) * 0.001f;
        } else {
            this._sTime = 0L;
            this._cTime = 0L;
            this._currTime = 0.0f;
        }
    }

    public float time() {
        return this._currTime;
    }

    public float getCurrTime() {
        return this._currTime;
    }

    public int getCurrFrame() {
        return this._currFrame;
    }

    public float getFrameTime() {
        return this._frameTime;
    }

    public float getFrameRate() {
        return this._frameRate;
    }
}

