/*
 * Decompiled with CFR 0.152.
 */
package vitamin.utils;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;

public class BufferUtils {
    public static IntBuffer createIntBuffer(int[] buf) {
        ByteBuffer bb = ByteBuffer.allocateDirect(buf.length * 4);
        bb.order(ByteOrder.nativeOrder());
        IntBuffer fb = bb.asIntBuffer();
        fb.put(buf);
        fb.position(0);
        fb.limit(buf.length);
        return fb;
    }

    public static IntBuffer createIntBuffer(int len) {
        ByteBuffer bb = ByteBuffer.allocateDirect(len * 4);
        bb.order(ByteOrder.nativeOrder());
        IntBuffer fb = bb.asIntBuffer();
        return fb;
    }

    public static FloatBuffer createFloatBuffer(float[] buf) {
        ByteBuffer bb = ByteBuffer.allocateDirect(buf.length * 4);
        bb.order(ByteOrder.nativeOrder());
        FloatBuffer fb = bb.asFloatBuffer();
        fb.put(buf);
        fb.position(0);
        fb.limit(buf.length);
        return fb;
    }

    public static FloatBuffer createFloatBuffer(int length) {
        ByteBuffer bb = ByteBuffer.allocateDirect(length * 4);
        bb.order(ByteOrder.nativeOrder());
        FloatBuffer fb = bb.asFloatBuffer();
        fb.position(0);
        fb.limit(length);
        return fb;
    }

    public static void addFloatBuffer(FloatBuffer buf, float v, int index) {
        buf.put(index, v);
    }

    public static void addFloatBuffer(FloatBuffer buf, float v) {
        buf.put(v);
    }

    public static void addFloatBuffer(FloatBuffer buf, float[] v) {
        buf.put(v);
    }

    public static void addIntBuffer(IntBuffer buf, int v, int index) {
        buf.put(index, v);
    }

    public static void addIntBuffer(IntBuffer buf, int v) {
        buf.put(v);
    }

    public static void addIntBuffer(IntBuffer buf, int[] v) {
        buf.put(v);
    }
}

