/*
 * Decompiled with CFR 0.152.
 */
package vitamin.scenesimple;

import java.util.ArrayList;
import vitamin.math.Vector3;
import vitamin.scenesimple.Mesh;
import vitamin.scenesimple.Vertex;

public class MeshCube
extends Mesh {
    private static final float _lengthToRadius = 0.8660254f;
    private static final float[] N = new float[]{0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f, -1.0f, 0.0f, -1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f};
    float _uMulti;
    float _vMulti;
    float _length;
    float _spherifyFactor;
    int _subdivision;
    Vector3 _center;

    public MeshCube(String name) {
        this._name = name;
        this._vertexList = new ArrayList();
        this._triangleList = new ArrayList();
        this._length = 1.0f;
        this._subdivision = 1;
        this._spherifyFactor = 0.0f;
    }

    public MeshCube(String name, float spherifyFactor, float length, int subdivision) {
        this._name = name;
        this._vertexList = new ArrayList();
        this._triangleList = new ArrayList();
        this._length = length;
        this._subdivision = subdivision;
        this._spherifyFactor = spherifyFactor;
    }

    public boolean generate() {
        if (this._vertexList != null) {
            this.release();
        }
        int vertexPerFace = (2 + this._subdivision) * (2 + this._subdivision);
        float sub = 1.0f / (float)(this._subdivision + 1);
        int iFace = 0;
        while (iFace < 6) {
            float Nx = N[iFace * 3 + 0];
            float Ny = N[iFace * 3 + 1];
            float Nz = N[iFace * 3 + 2];
            float Hx = N[iFace * 3 + 3];
            float Hy = N[iFace * 3 + 4];
            float Hz = N[iFace * 3 + 5];
            float Vx = Ny * Hz + Nz * Hy;
            float Vy = Nz * Hx + Nx * Hz;
            float Vz = Nx * Hy + Ny * Hx;
            int iLine = 0;
            while (iLine < 2 + this._subdivision) {
                float kLine = (float)iLine * sub - 0.5f;
                Vector3 M = new Vector3();
                int iColumn = 0;
                while (iColumn < 2 + this._subdivision) {
                    Vertex vert;
                    float kColumn = (float)iColumn * sub - 0.5f;
                    M.x = Nx * 0.5f + kLine * Vx + kColumn * Hx;
                    M.y = Ny * 0.5f + kLine * Vy + kColumn * Hy;
                    M.z = Nz * 0.5f + kLine * Vz + kColumn * Hz;
                    if (this._spherifyFactor == 0.0f) {
                        vert = new Vertex();
                        vert.setPosition(M.x * this._length, M.y * this._length, M.z * this._length);
                        vert.setNormal(Nx, Ny, Nz);
                        this.addVertex(vert);
                    } else if (this._spherifyFactor == 1.0f) {
                        M.normalize();
                        vert = new Vertex();
                        vert.setPosition(M.x * this._length * 0.8660254f, M.y * this._length * 0.8660254f, M.z * this._length * 0.8660254f);
                        vert.setNormal(M.x, M.y, M.z);
                        this.addVertex(vert);
                    } else {
                        Vector3 M1 = M.copy();
                        M1.normalize();
                        Vertex vert2 = new Vertex();
                        vert2._position.x = (M.x * (1.0f - this._spherifyFactor) + M1.x * this._spherifyFactor * 0.8660254f) * this._length;
                        vert2._position.y = (M.y * (1.0f - this._spherifyFactor) + M1.y * this._spherifyFactor * 0.8660254f) * this._length;
                        vert2._position.z = (M.z * (1.0f - this._spherifyFactor) + M1.z * this._spherifyFactor * 0.8660254f) * this._length;
                        M.x = Nx * (1.0f - this._spherifyFactor) + M1.x * this._spherifyFactor;
                        M.y = Ny * (1.0f - this._spherifyFactor) + M1.y * this._spherifyFactor;
                        M.z = Nz * (1.0f - this._spherifyFactor) + M1.z * this._spherifyFactor;
                        M.normalize();
                        vert2._normal.x = M.x;
                        vert2._normal.y = M.y;
                        vert2._normal.z = M.z;
                        vert2._texCoord.x = (float)iLine / (float)(2 + this._subdivision) * this._uMulti;
                        vert2._texCoord.y = (float)iColumn / (float)(2 + this._subdivision) * this._vMulti;
                        this.addVertex(vert2);
                    }
                    ++iColumn;
                }
                ++iLine;
            }
            this._hasNormals = true;
            iLine = 0;
            while (iLine < 1 + this._subdivision) {
                int i0 = vertexPerFace * iFace + iLine * (this._subdivision + 2);
                int iColumn = 0;
                while (iColumn < 1 + this._subdivision) {
                    int j0 = i0 + iColumn;
                    int a1 = j0 + 0;
                    int b1 = j0 + (this._subdivision + 2);
                    int c1 = j0 + 1;
                    this.addTriangle(a1, b1, c1);
                    int a2 = j0 + 1;
                    int b2 = j0 + (this._subdivision + 2);
                    int c2 = j0 + (this._subdivision + 2) + 1;
                    this.addTriangle(a2, b2, c2);
                    ++iColumn;
                }
                ++iLine;
            }
            ++iFace;
        }
        return true;
    }

    public void setUVMultiplier(float um, float vm) {
        this._uMulti = um;
        this._vMulti = vm;
    }

    public void setCenter(Vector3 center) {
        this._center = center;
    }

    public void setSubdivision(int s) {
        this._subdivision = s;
    }

    public void setParams(float len, float spherify, int subdivision) {
        this._length = len;
        this._spherifyFactor = spherify;
        this._subdivision = subdivision;
    }
}

