/*
 * Decompiled with CFR 0.152.
 */
package vitamin.math;

import vitamin.math.Matrix;

public class Color4 {
    public static final Color4 WHITE = new Color4(1.0f, 1.0f, 1.0f, 1.0f);
    public static final Color4 BLACK = new Color4(0.0f, 0.0f, 0.0f, 1.0f);
    public float r;
    public float g;
    public float b;
    public float a;

    public Color4() {
        this.a = 0.0f;
        this.b = 0.0f;
        this.g = 0.0f;
        this.r = 0.0f;
    }

    public Color4(int rr, int gg, int bb) {
        this.r = (float)rr / 255.0f;
        this.g = (float)gg / 255.0f;
        this.b = (float)bb / 255.0f;
        this.a = 1.0f;
    }

    public Color4(float xx, float yy, float zz, float ww) {
        this.r = xx;
        this.g = yy;
        this.b = zz;
        this.a = ww;
    }

    public Color4(Color4 v) {
        this.r = v.r;
        this.g = v.g;
        this.b = v.b;
        this.a = v.a;
    }

    public void set(float xx, float yy, float zz, float ww) {
        this.r = xx;
        this.g = yy;
        this.b = zz;
        this.a = ww;
    }

    public void reset() {
        this.r = 0.0f;
        this.g = 0.0f;
        this.b = 0.0f;
        this.a = 0.0f;
    }

    public Color4 copy() {
        return new Color4(this.r, this.g, this.b, this.a);
    }

    public Color4 clone() {
        return new Color4(this.r, this.g, this.b, this.a);
    }

    public void clamp() {
        if (this.r < 0.0f) {
            this.r = 0.0f;
        }
        if (this.g < 0.0f) {
            this.g = 0.0f;
        }
        if (this.b < 0.0f) {
            this.b = 0.0f;
        }
        if (this.a < 0.0f) {
            this.a = 0.0f;
        }
        if (this.r > 1.0f) {
            this.r = 1.0f;
        }
        if (this.g > 1.0f) {
            this.g = 1.0f;
        }
        if (this.b > 1.0f) {
            this.b = 1.0f;
        }
        if (this.a > 1.0f) {
            this.a = 1.0f;
        }
    }

    public void add(Color4 v) {
        this.r += v.r;
        this.g += v.g;
        this.b += v.b;
        this.a += v.a;
    }

    public void sub(Color4 v) {
        this.r -= v.r;
        this.g -= v.g;
        this.b -= v.b;
        this.a *= v.a;
    }

    public void mul(Color4 v) {
        this.r *= v.r;
        this.g *= v.g;
        this.b *= v.b;
        this.a *= v.a;
    }

    public void div(Color4 v) {
        this.r /= v.r;
        this.g /= v.g;
        this.b /= v.b;
        this.a /= v.a;
    }

    public void mul(float s) {
        this.r *= s;
        this.g *= s;
        this.b *= s;
        this.a *= s;
    }

    public void div(float s) {
        float inv = 1.0f / s;
        this.r *= inv;
        this.g *= inv;
        this.b *= inv;
        this.a *= inv;
    }

    public float dot(Color4 v) {
        return this.r * v.r + this.g * v.g + this.b * v.b + this.a * v.a;
    }

    public float length() {
        return (float)Math.sqrt(this.r * this.r + this.g * this.g + this.b * this.b);
    }

    public float lengthSqr() {
        return this.r * this.r + this.g * this.g + this.b * this.b;
    }

    public void normalize() {
        float m = this.length();
        if (m > 0.0f) {
            this.div(m);
        }
    }

    public Color4 lerp(Color4 V1, float s) {
        return new Color4(this.r + s * (V1.r - this.r), this.g + s * (V1.g - this.g), this.b + s * (V1.b - this.b), this.a + s * (V1.a - this.a));
    }

    public Color4 transform(Matrix m) {
        float xr = this.r * m._M[0] + this.g * m._M[4] + this.b * m._M[8];
        float yg = this.r * m._M[1] + this.g * m._M[5] + this.b * m._M[9];
        float zb = this.r * m._M[2] + this.g * m._M[6] + this.b * m._M[10];
        float wa = 0.0f;
        return new Color4(xr, yg, zb, wa);
    }

    public static Color4 add(Color4 a, Color4 b) {
        return new Color4(a.r + b.r, a.g + b.g, a.b + b.b, a.a + b.a);
    }

    public static Color4 sub(Color4 a, Color4 b) {
        return new Color4(a.r - b.r, a.g - b.g, a.b - b.b, a.a - b.a);
    }

    public static Color4 mul(Color4 a, Color4 b) {
        return new Color4(a.r * b.r, a.g * b.g, a.b * b.b, a.a * b.a);
    }

    public static Color4 mul(Color4 a, float f) {
        return new Color4(a.r * f, a.g * f, a.b * f, a.a * f);
    }

    public static Color4 lerp(Color4 c1, Color4 c2, float s) {
        return new Color4(c1.r + s * (c2.r - c1.r), c1.g + s * (c2.g - c1.g), c1.b + s * (c2.b - c1.b), c1.a + s * (c2.a - c1.a));
    }

    public static float distance(Color4 v1, Color4 v2) {
        float dr = v1.r - v2.r;
        float dg = v1.g - v2.g;
        float db = v1.b - v2.b;
        return (float)Math.sqrt(dr * dr + dg * dg + db * db);
    }

    public static float angleBetween(Color4 v1, Color4 v2) {
        float dot = v1.dot(v2);
        float theta = (float)Math.acos(dot / (v1.length() * v2.length()));
        return theta;
    }

    public static float toFloat(int c) {
        return (float)c / 255.0f;
    }

    public void debug() {
        System.out.println(String.valueOf(this.r) + ", " + this.g + ", " + this.b + ", " + this.a);
    }

    public String toString() {
        return new String(String.valueOf(this.r) + ", " + this.g + ", " + this.b + ", " + this.a);
    }
}

