/*
 * Decompiled with CFR 0.152.
 */
package vitamin.fx;

import java.util.HashMap;
import java.util.Vector;
import vitamin.fx.TimelineLayer;

public class Timeline {
    public static final int LINEAR = 0;
    public static final int COSINE = 1;
    public static final int CUBIC = 2;
    public static final int CIRCULAR = 3;
    boolean _isRealtime;
    int _framesPerSecond;
    int _currFrame;
    float _currTime;
    Vector<TimelineLayer> _layers;
    HashMap<String, TimelineLayer> _layerList;

    public Timeline() {
        this._isRealtime = true;
        this._framesPerSecond = 0;
        this._currFrame = 0;
        this._currTime = 0.0f;
        this._layers = new Vector();
    }

    public Timeline(boolean realtime, int fps) {
        this._isRealtime = realtime;
        this._framesPerSecond = fps;
        this._currFrame = 0;
        this._currTime = 0.0f;
        this._layers = new Vector();
    }

    public void addVariable(String name) {
        this.addVariable(name, 0);
    }

    public void addVariable(String name, int lerpMode) {
        if (name == null) {
            System.err.println("(Timeline) Invalid variable name.");
            return;
        }
        if (this.getLayer(name) != null) {
            System.err.println("(Timeline) There is already a layer with this name.");
        }
        System.out.println("(Timeline) New Variable Added to Timeline with name: " + name + "  (" + this._layers.size() + ")");
        this._layers.add(new TimelineLayer(name, lerpMode));
    }

    public void addVariableTime(String name, float position, float value) {
        TimelineLayer t = this.getLayer(name);
        if (t == null) {
            this.addVariable(name, 0);
            t = this.getLayer(name);
            t.addValue(position, value);
            return;
        }
        if (t != null) {
            t.addValue(position, value);
        }
    }

    public float getValue(String name) {
        TimelineLayer t = this.getLayer(name);
        if (t == null) {
            System.err.println("(Timeline) Invalid variable name. returning -99999f");
            return -99999.0f;
        }
        return t.getCurrValue();
    }

    public TimelineLayer getLayer(String name) {
        for (TimelineLayer variable : this._layers) {
            if (!variable.getName().equals(name)) continue;
            return variable;
        }
        return null;
    }

    public void update(float frameTime) {
        ++this._currFrame;
        this._currTime = this._isRealtime ? (this._currTime += frameTime) : (this._currTime += 1.0f / (float)this._framesPerSecond);
        for (TimelineLayer variable : this._layers) {
            variable.update(this._currTime);
        }
    }

    public void release() {
        for (TimelineLayer variable : this._layers) {
            variable.release();
        }
        this._layers.clear();
    }
}

