/*
 * Decompiled with CFR 0.152.
 */
package vitamin.scenegraph;

import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import vitamin.scenegraph.Camera;
import vitamin.scenegraph.Light;
import vitamin.scenegraph.SceneNode;

public class Scene {
    Map<String, SceneNode> _objMap;
    int _numCameras;
    Vector<Camera> _cameraList = new Vector();
    int _numLights;
    Vector<Light> _lightList = new Vector();
    int _currCamIdx;
    Camera _currCam;
    SceneNode _root;

    public Scene() {
        this._objMap = new HashMap<String, SceneNode>();
    }

    public void addChild(SceneNode n) {
        if (this._root == null) {
            this._root = new SceneNode();
        }
        this._root.addChild(n);
    }

    public SceneNode addChild(String name) {
        if (this._root == null) {
            this._root = new SceneNode();
        }
        SceneNode sn = new SceneNode(name);
        this._root.addChild(sn);
        this._objMap.put(sn.getName(), sn);
        return sn;
    }

    public void addCamera(Camera c) {
        this._cameraList.add(c);
    }

    public void addLight(Light l) {
        this._lightList.add(l);
    }

    public int getCameraIdx() {
        return this._currCamIdx;
    }

    public Camera getCamera() {
        return this._currCam;
    }

    public boolean activateCamera(String name) {
        int i = 0;
        while (i < this._cameraList.size()) {
            Camera c = this._cameraList.get(i);
            if (name == c._name) {
                this._currCam = c;
                return true;
            }
            ++i;
        }
        return false;
    }

    public void render() {
        if (this._root != null) {
            this._root.render();
        }
    }

    public void traverseTopDown() {
        int i = 0;
        while (i < this._root._numChildren) {
            SceneNode n = this._root._children.get(i);
            System.out.println(String.valueOf(n._name) + ": " + n._position.x + "," + n._position.y + "," + n._position.z);
            n.traverseTopDown();
            ++i;
        }
    }
}

