/*
 * Decompiled with CFR 0.152.
 */
package vitamin.interpolation;

import vitamin.interpolation.Interpolator;

public class WeightedAverage
implements Interpolator {
    public static float easeIn(float t, float b, float c, float d) {
        if (t > d) {
            return c;
        }
        float v = WeightedAverage.getWeighted(t / d, c, d);
        return b + (c - b) * v;
    }

    public static float easeOut(float t, float b, float c, float d) {
        if (t > d) {
            return c;
        }
        float v = WeightedAverage.getWeighted(t / d, c, d);
        return b + (c - b) * v;
    }

    public static float easeInOut(float t, float b, float c, float d) {
        if (t > d) {
            return c;
        }
        float v = WeightedAverage.getWeighted(t / d, c, d);
        return v;
    }

    private static float getWeighted(float v, float w, float N) {
        return (v * (N - 1.0f) + w) / N;
    }
}

