/*
 * Decompiled with CFR 0.152.
 */
package vitamin.fx;

import java.util.Vector;
import javax.media.opengl.GL;
import vitamin.fx.Effect;

public class EffectManager {
    int _effectCount;
    Vector<Integer> _activeEffectsID;
    Vector<Effect> _effectList;
    GL _gl;

    public EffectManager(GL gl) {
        this._gl = gl;
        this._activeEffectsID = new Vector();
        this._effectList = new Vector();
    }

    public int AddEffect(Effect fx) {
        this._effectList.add(fx);
        int fxId = this._effectCount++;
        return fxId;
    }

    public void RemoveEffectById(int id) {
        this._effectList.removeElementAt(id);
        this._activeEffectsID.remove(id);
        --this._effectCount;
    }

    public void process() {
        for (Effect fx : this._effectList) {
            fx.Init(this._gl);
        }
    }

    public boolean Render(float time) {
        for (Effect fx : this._effectList) {
            if (!fx.checkActivity(time)) continue;
            fx.InnerRender(time);
            fx.Update(time);
        }
        return true;
    }

    public boolean RenderEffect(int fxID, float time) {
        this._effectList.get(fxID).Render(time);
        return true;
    }

    public void Release() {
        for (Effect fx : this._effectList) {
            fx.Release();
        }
        this._effectList.clear();
        this._activeEffectsID.clear();
    }

    public Effect getEffectByIdx(int idx) {
        return this._effectList.get(idx);
    }

    public int getCount() {
        return this._effectCount;
    }
}

