/*
 * Decompiled with CFR 0.152.
 */
package vitamin;

import java.awt.AWTException;
import java.awt.IllegalComponentStateException;
import java.awt.Point;
import java.awt.Robot;
import java.awt.event.MouseEvent;
import processing.core.PApplet;
import vitamin.math.Quaternion;
import vitamin.math.Vector2;
import vitamin.math.Vector3;
import vitamin.scenegraph.Camera;

public class VCamera
extends Camera {
    Vector3 _strafe;
    float _rotationAngle;
    float _speed;
    float _sensitivity;
    float _damp;
    float _mx;
    float _my;
    float _mxdrag;
    float _mydrag;
    Vector2 _mousePos;
    Vector2 _mouseDiff;
    private PApplet parent;
    private Robot robot;

    public VCamera(PApplet p) {
        this("DefaultCamera", p, 0.0f, 0.0f, 10.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f);
    }

    public VCamera(String name, PApplet p) {
        this("DefaultCamera", p, 0.0f, 0.0f, 10.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f);
    }

    public VCamera(PApplet p, Vector3 e, Vector3 t, Vector3 u) {
        this("DefaultCamera", p, e.x, e.y, e.z, t.x, t.y, t.z, u.x, u.y, u.z);
    }

    public VCamera(PApplet p, float ex, float ey, float ez, float tx, float ty, float tz, float ux, float uy, float uz) {
        this("DefaultCamera", p, ex, ey, ez, tx, ty, tz, ux, uy, uz);
    }

    public VCamera(String name, PApplet p, float ex, float ey, float ez, float tx, float ty, float tz, float ux, float uy, float uz) {
        this._name = name;
        this.parent = p;
        this.parent.registerMouseEvent((Object)this);
        try {
            this.robot = new Robot();
        }
        catch (AWTException e) {
            System.err.println("(VCamera)  Failed on robot allocation");
        }
        this._mousePos = new Vector2();
        this._mouseDiff = new Vector2();
        this._rotationAngle = 0.0f;
        this._position = new Vector3(ex, ey, ez);
        this._target = new Vector3(tx, ty, tz);
        this._up = new Vector3(ux, uy, uz);
        this._strafe = new Vector3();
        this._right = new Vector3();
        this._dir = Vector3.sub(this._target, this._position);
        this._damp = 0.95f;
        this._speed = 5.0f;
        this._sensitivity = 0.2f;
    }

    public void mouseEvent(MouseEvent event) {
        switch (event.getID()) {
            case 501: {
                this.mousePressed();
                break;
            }
            case 502: {
                this.mouseReleased();
                break;
            }
            case 500: {
                break;
            }
            case 506: {
                this.mouseDragged();
                break;
            }
        }
    }

    public void move() {
        this._dir = Vector3.sub(this._target, this._position);
        this._dir.normalize();
        this.update(this._dir, this._speed);
    }

    public void move(float speed) {
        this._dir = Vector3.sub(this._target, this._position);
        this._dir.normalize();
        this.update(this._dir, speed);
    }

    public void lift() {
        this.update(this._up, this._speed);
    }

    public void lift(float speed) {
        this.update(this._up, speed);
    }

    public void strafe() {
        this._dir = Vector3.sub(this._target, this._position);
        this._dir.normalize();
        this._strafe = Vector3.cross(this._dir, this._up);
        this._strafe.normalize();
        this._right = this._strafe.copy();
        this.update(this._strafe, this._speed);
    }

    public void strafe(float speed) {
        this._dir = Vector3.sub(this._target, this._position);
        this._dir.normalize();
        this._strafe = Vector3.cross(this._dir, this._up);
        this._strafe.normalize();
        this.update(this._strafe, speed);
    }

    private void update(Vector3 vdir, float speed) {
        this._dir = vdir.copy();
        Vector3 tmp = vdir.copy();
        tmp.mul(speed);
        this._position.add(tmp);
        this._target.add(tmp);
        this._strafe = Vector3.cross(vdir, this._up);
        this._strafe.normalize();
        this._right = this._strafe.copy();
        this._up = Vector3.UP;
    }

    public void rotateQuat(Vector3 axis, float rotAngle) {
        Quaternion qRotate = new Quaternion();
        Quaternion qView = new Quaternion();
        qRotate.rotateAxis(axis, rotAngle);
        Vector3 view = Vector3.sub(this._target, this._position);
        qView.set(view, 0.0f);
        Quaternion newView = Quaternion.mul(qRotate, qView);
        qRotate.conjugate();
        newView = Quaternion.mul(newView, qRotate);
        this._target.x = this._position.x + newView.x;
        this._target.y = this._position.y + newView.y;
        this._target.z = this._position.z + newView.z;
    }

    public void rotateByMouse(int mousePosX, int mousePosY, int midX, int midY) {
        float yDirection = 0.0f;
        float yRotation = 0.0f;
        if (this.parent.firstMouse) {
            return;
        }
        if (mousePosX == midX && mousePosY == midY) {
            return;
        }
        yDirection = (float)(midX - mousePosX) * this._sensitivity;
        yRotation = (float)(midY - mousePosY) * this._sensitivity;
        this._rotationAngle -= yRotation;
        if (this._rotationAngle > 90.0f) {
            this._rotationAngle = 90.0f;
            return;
        }
        if (this._rotationAngle < -90.0f) {
            this._rotationAngle = -90.0f;
            return;
        }
        Vector3 view = Vector3.sub(this._target, this._position);
        view.normalize();
        Vector3 axis = Vector3.cross(view, this._up);
        axis.normalize();
        this.rotateQuat(axis, yRotation * (float)Math.PI / 180.0f);
        this.rotateQuat(this._up, yDirection * (float)Math.PI / 180.0f);
        this.setToCenter();
    }

    public void rotateByMouse() {
        float yDirection = 0.0f;
        float yRotation = 0.0f;
        this.updateRotate();
        float mouseDeltaX = this._mx * this._sensitivity;
        float mouseDeltaY = this._my * this._sensitivity;
        yDirection = mouseDeltaX;
        yRotation = mouseDeltaY;
        this._rotationAngle -= yRotation;
        if (this._rotationAngle >= 80.0f) {
            this._rotationAngle = 80.0f;
            return;
        }
        if (this._rotationAngle <= -80.0f) {
            this._rotationAngle = -80.0f;
            return;
        }
        Vector3 view = Vector3.sub(this._target, this._position);
        view.normalize();
        Vector3 axis = Vector3.cross(view, this._up);
        axis.normalize();
        this.rotateQuat(axis, yRotation * (float)Math.PI / 180.0f);
        this.rotateQuat(this._up, yDirection * (float)Math.PI / 180.0f);
    }

    private void updateRotate() {
        this._mx += this._mouseDiff.x;
        this._my += this._mouseDiff.y;
        this._mx *= this._damp;
        this._my *= this._damp;
        this._mouseDiff.reset();
    }

    public void mousePressed() {
        this._mouseDiff.reset();
        this._mousePos.set(this.parent.mouseX, this.parent.mouseY);
    }

    public void mouseDragged() {
        this._mouseDiff.set(this._mousePos.x - (float)this.parent.mouseX, this._mousePos.y - (float)this.parent.mouseY);
        this._mousePos.set(this.parent.mouseX, this.parent.mouseY);
    }

    public void mouseReleased() {
        this._mousePos.reset();
    }

    public void setDamp(float damp) {
        this._damp = damp;
    }

    public void setSensitivity(float sense) {
        this._sensitivity = sense;
    }

    public void setSpeed(float speed) {
        this._speed = speed;
    }

    public void setPosition(float x, float y, float z) {
        this._position.x = x;
        this._position.y = y;
        this._position.z = z;
    }

    public void setPosition(Vector3 v) {
        this._position.x = v.x;
        this._position.y = v.y;
        this._position.z = v.z;
    }

    public void setTarget(float x, float y, float z) {
        this._target.x = x;
        this._target.y = y;
        this._target.z = z;
    }

    public void setTarget(Vector3 v) {
        this._target.x = v.x;
        this._target.y = v.y;
        this._target.z = v.z;
    }

    public void setUp(float x, float y, float z) {
        this._up.x = x;
        this._up.y = y;
        this._up.z = z;
    }

    public void setUp(Vector3 v) {
        this._up.x = v.x;
        this._up.y = v.y;
        this._up.z = v.z;
    }

    public void setMousePosition(float xScale, float yScale) {
        Point p = this.getWindowTopLeft();
        try {
            this.robot.mouseMove((int)(xScale * (float)this.parent.width + (float)p.x), (int)(yScale * (float)this.parent.height + (float)p.y));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void setToCenter() {
        this.setMousePosition(0.5f, 0.5f);
    }

    public Vector3 getRelativePosition() {
        if (this.parent.firstMouse || this.parent.mouseX == 0 && this.parent.mouseY == 0) {
            return new Vector3(0.5f, 0.5f, 0.0f);
        }
        return new Vector3((float)this.parent.mouseX / (float)this.parent.width, (float)this.parent.mouseY / (float)this.parent.height, 0.0f);
    }

    public Point getWindowTopLeft() {
        Point p;
        try {
            p = this.parent.getLocationOnScreen();
        }
        catch (IllegalComponentStateException i) {
            p = new Point(this.parent.screen.width / 2 - this.parent.width / 2, this.parent.screen.height / 2 - this.parent.height / 2);
        }
        return p;
    }

    public Vector3 getPosition() {
        return this._position;
    }

    public Vector3 getTarget() {
        return this._target;
    }

    public Vector3 getUp() {
        return this._up;
    }

    public Vector3 getRight() {
        return this._right;
    }
}

