/*
 * Decompiled with CFR 0.152.
 */
package vitamin;

import java.nio.Buffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.HashMap;
import java.util.Map;
import javax.media.opengl.GL;
import javax.media.opengl.glu.GLU;
import processing.core.PApplet;
import processing.opengl.PGraphicsOpenGL;
import vitamin.Shader;
import vitamin.ShaderCGFX;
import vitamin.ShaderManager;
import vitamin.VGLext;
import vitamin.VLogger;
import vitamin.VSamplerState;
import vitamin.VTexture;
import vitamin.VTexture2D;
import vitamin.math.Matrix;
import vitamin.math.Vector3;
import vitamin.math.Vector4;
import vitamin.scenesimple.MMLoader;
import vitamin.scenesimple.Scene;
import vitamin.utils.VStringUtils;

public class VGL {
    public static final float BLACK = 0.0f;
    public static final float WHITE = 1.0f;
    public static final int PROJECTION = 0;
    public static final int MODELVIEW = 1;
    public static final int TEXTURE = 2;
    public static final int POINTS = 0;
    public static final int LINES = 1;
    public static final int TRIANGLES = 2;
    public static final int QUADS = 3;
    public static final int LINE_STRIP = 4;
    public static final int TRIANGLE_STRIP = 5;
    public static final int QUAD_STRIP = 6;
    public static final int BLEND_ADD = 0;
    public static final int BLEND_SUBTRACT = 1;
    public static final int BLEND_REVERSE_SUBTRACT = 2;
    private static VGL _singleton;
    private boolean _debugMode;
    private VGLext _extensions;
    private boolean vSyncEnabled;
    boolean _useProcessing;
    private PApplet _parent;
    private GL _gl;
    private GLU _glu;
    private int _width;
    private int _height;
    public float _r;
    public float _g;
    public float _b;
    public float _a;
    boolean _flipV;
    private float _uScale;
    private float _vScale;
    private float _uOffset;
    private float _vOffset;
    private ShaderManager _shaderMan;
    private int _numTextures;
    private Map<Integer, VTexture> _texturePool;
    public Matrix _projMatrix;

    private VGL() {
        this.init(null, null, null, false, false);
    }

    public VGL(PApplet parent) {
        this._width = parent.width;
        this._height = parent.height;
        this.init(parent, ((PGraphicsOpenGL)parent.g).gl, ((PGraphicsOpenGL)parent.g).glu, true, false);
    }

    public VGL(PApplet parent, boolean debugMode) {
        this._width = parent.width;
        this._height = parent.height;
        this.init(parent, ((PGraphicsOpenGL)parent.g).gl, ((PGraphicsOpenGL)parent.g).glu, true, debugMode);
    }

    public VGL(GL gl, GLU glu) {
        System.err.println("(VGL)  Application is not using processing. You should set Width and Height manually!");
        this.init(null, gl, glu, false, false);
    }

    public VGL(GL gl, GLU glu, boolean debugMode) {
        System.err.println("(VGL)  Application is not using processing. You should set Width and Height manually!");
        this.init(null, gl, glu, false, debugMode);
    }

    public VGL(GL gl, GLU glu, int w, int h) {
        this.init(null, gl, glu, false, false);
        this.setDimensions(w, h);
    }

    public void init(PApplet parent, GL gl, GLU glu, boolean useProcessingGL, boolean debugMode) {
        this._useProcessing = useProcessingGL;
        this._debugMode = debugMode;
        if (debugMode) {
            VLogger.getSingleton().setFileName("vitamin.txt");
            VLogger.getSingleton().setEnable(debugMode);
        }
        if (useProcessingGL) {
            this._parent = parent;
            this._gl = gl;
            this._glu = glu;
        } else {
            this._parent = null;
            this._gl = gl;
            this._glu = glu;
        }
        this._uScale = 1.0f;
        this._vScale = 1.0f;
        this._flipV = false;
        this._uOffset = 0.0f;
        this._vOffset = 0.0f;
        this._r = 1.0f;
        this._g = 1.0f;
        this._b = 1.0f;
        this._a = 1.0f;
        this._extensions = new VGLext(this);
        this._shaderMan = new ShaderManager(this._gl);
    }

    public void setDimensions(int w, int h) {
        this._width = w;
        this._height = h;
    }

    public GL gl() {
        return this._gl;
    }

    public GLU glu() {
        return this._glu;
    }

    public void setGL(GL gl) {
        this._gl = gl;
    }

    public void setGLU(GLU glu) {
        this._glu = glu;
    }

    public void begin() {
        if (this._parent == null && this._glu == null && this._glu == null) {
            System.err.println("(VGL)  Renderer hasn't been initialized. init() must be called before use.");
            return;
        }
        if (this._useProcessing) {
            this._glu = ((PGraphicsOpenGL)this._parent.g).glu;
            this._gl = ((PGraphicsOpenGL)this._parent.g).beginGL();
        }
    }

    public void begin(GL gl) {
        if (this._parent == null && this._glu == null && this._glu == null) {
            System.err.println("(VGL)  Renderer hasn't been initialized. init() must be called before use.");
            return;
        }
        if (this._useProcessing) {
            this._glu = ((PGraphicsOpenGL)this._parent.g).glu;
            this._gl = gl;
        }
    }

    public void end() {
        if (this._useProcessing) {
            ((PGraphicsOpenGL)this._parent.g).endGL();
        }
    }

    public void logMessage(String msg) {
        VLogger.getSingleton().log(msg);
    }

    public void log(String msg) {
        VLogger.getSingleton().log(msg);
    }

    public void background(float c) {
        this._gl.glClearColor(c, c, c, 1.0f);
        this._gl.glClear(16640);
    }

    public void background(float r, float g, float b) {
        this._gl.glClearColor(r, g, b, 1.0f);
        this._gl.glClear(16640);
    }

    public void background(float r, float g, float b, float a) {
        this._gl.glClearColor(r, g, b, a);
        this._gl.glClear(16640);
    }

    public void ortho(float left, float right, float top, float bottom, float near, float far) {
        this._gl.glMatrixMode(5889);
        this._gl.glLoadIdentity();
        this._gl.glOrtho((double)left, (double)right, (double)bottom, (double)top, (double)near, (double)far);
        this._gl.glMatrixMode(5888);
        this._gl.glLoadIdentity();
    }

    public void ortho() {
        this.ortho(-1.0f, 1.0f, -1.0f, 1.0f, -1.0f, 1.0f);
    }

    public void ortho(float width, float height) {
        this._gl.glMatrixMode(5889);
        this._gl.glLoadIdentity();
        this._gl.glOrtho(0.0, (double)width, (double)height, 0.0, -100.0, 100.0);
        this._gl.glMatrixMode(5888);
        this._gl.glLoadIdentity();
    }

    public void ortho(float left, float right, float top, float bottom) {
        this._gl.glMatrixMode(5889);
        this._gl.glLoadIdentity();
        this._gl.glOrtho((double)left, (double)right, (double)bottom, (double)top, -100.0, 100.0);
        this._gl.glMatrixMode(5888);
        this._gl.glLoadIdentity();
    }

    public boolean orthoOffCenter(float left, float right, float top, float bottom, float nearPlane, float farPlane) {
        float width = right - left;
        float height = bottom - top;
        if (Math.abs(width) < 0.01f) {
            return false;
        }
        if (Math.abs(height) < 0.01f) {
            return false;
        }
        float nfRatio = farPlane - nearPlane;
        if (Math.abs(nfRatio) < 0.01f) {
            return false;
        }
        nfRatio = 1.0f / nfRatio;
        if (this._projMatrix == null) {
            this._projMatrix = new Matrix();
        }
        this._projMatrix._M[0] = 2.0f / width;
        this._projMatrix._M[5] = 2.0f / height;
        this._projMatrix._M[10] = nfRatio;
        this._projMatrix._M[12] = -(left + right) / width;
        this._projMatrix._M[13] = -(top + bottom) / height;
        this._projMatrix._M[14] = -nfRatio * nearPlane;
        this._projMatrix._M[15] = 1.0f;
        this._gl.glMatrixMode(5889);
        this._gl.glLoadIdentity();
        this._gl.glLoadMatrixf(this._projMatrix.getFloatBuffer());
        return true;
    }

    public void perspective(float fovy, float aspect, float nearZ, float farZ) {
        this._gl.glMatrixMode(5889);
        this._gl.glLoadIdentity();
        this._glu.gluPerspective((double)fovy, (double)aspect, (double)nearZ, (double)farZ);
    }

    public void camera(float ex, float ey, float ez, float tx, float ty, float tz, float ux, float uy, float uz) {
        this._gl.glMatrixMode(5888);
        this._gl.glLoadIdentity();
        this._glu.gluLookAt((double)ex, (double)ey, (double)ez, (double)tx, (double)ty, (double)tz, (double)ux, (double)uy, (double)uz);
    }

    public void camera(Vector3 e, Vector3 t, Vector3 u) {
        this._gl.glMatrixMode(5888);
        this._gl.glLoadIdentity();
        this._glu.gluLookAt((double)e.x, (double)e.y, (double)e.z, (double)t.x, (double)t.y, (double)t.z, (double)u.x, (double)u.y, (double)u.z);
    }

    public void camera(float ex, float ey, float ez, float tx, float ty, float tz) {
        this._gl.glMatrixMode(5888);
        this._gl.glLoadIdentity();
        this._glu.gluLookAt((double)ex, (double)ey, (double)ez, (double)tx, (double)ty, (double)tz, 0.0, 1.0, 0.0);
    }

    public void camera(Vector3 e, Vector3 t) {
        this._gl.glMatrixMode(5888);
        this._gl.glLoadIdentity();
        this._glu.gluLookAt((double)e.x, (double)e.y, (double)e.z, (double)t.x, (double)t.y, (double)t.z, 0.0, 1.0, 0.0);
    }

    public void viewport(int x2, int y2) {
        this.viewport(0, 0, x2, y2);
    }

    public void viewport(int x1, int y1, int x2, int y2) {
        this._gl.glViewport(x1, y1, x2, y2);
    }

    public void identity() {
        this.identity(1);
    }

    public void identity(int mode) {
        switch (mode) {
            case 0: {
                this._gl.glMatrixMode(5889);
                this._gl.glLoadIdentity();
                break;
            }
            case 1: {
                this._gl.glMatrixMode(5888);
                this._gl.glLoadIdentity();
                break;
            }
            case 2: {
                this._gl.glMatrixMode(5890);
                this._gl.glLoadIdentity();
                break;
            }
            default: {
                System.err.println("(VGL)  identity: parameter is not supported");
            }
        }
    }

    public void setProjectionMode() {
        this._gl.glMatrixMode(5889);
    }

    public void setViewMode() {
        this._gl.glMatrixMode(5888);
    }

    public void clearProjectionMatrix() {
        this._gl.glMatrixMode(5889);
        this._gl.glLoadIdentity();
    }

    public void clearViewMatrix() {
        this._gl.glMatrixMode(5888);
        this._gl.glLoadIdentity();
    }

    public void setMatrixState(int mode) {
        switch (mode) {
            case 0: {
                this._gl.glMatrixMode(5889);
                break;
            }
            case 1: {
                this._gl.glMatrixMode(5888);
                break;
            }
            case 2: {
                this._gl.glMatrixMode(5890);
                break;
            }
            default: {
                System.err.println("(VGL)  setMatrixState: parameter is not supported");
            }
        }
    }

    public Matrix getMatrix(int type) {
        Matrix m = new Matrix();
        m.identity();
        switch (type) {
            case 0: {
                this._gl.glGetFloatv(2983, m.getFloatBuffer());
                break;
            }
            case 1: {
                this._gl.glGetFloatv(2982, m.getFloatBuffer());
                break;
            }
            case 2: {
                this._gl.glGetFloatv(2984, m.getFloatBuffer());
                break;
            }
            default: {
                System.err.println("(VGL)  getMatrix: parameter is not supported");
            }
        }
        return m;
    }

    public Matrix getProjMatrix() {
        return this.getMatrix(0);
    }

    public Matrix getViewMatrix() {
        return this.getMatrix(1);
    }

    public Matrix getTextureMatrix() {
        return this.getMatrix(2);
    }

    public Matrix getTransposeProjMatrix() {
        Matrix m = new Matrix();
        this._gl.glGetFloatv(34020, m.getFloatBuffer());
        return m;
    }

    public Matrix getTransposeViewMatrix() {
        Matrix m = new Matrix();
        this._gl.glGetFloatv(34019, m.getFloatBuffer());
        return m;
    }

    public float[] getTransposeProjMatrixArray() {
        float[] m = new float[16];
        this._gl.glGetFloatv(34020, m, 0);
        return m;
    }

    public float[] getTransposeViewMatrixArray() {
        float[] m = new float[16];
        this._gl.glGetFloatv(34019, m, 0);
        return m;
    }

    public void translate(float x, float y) {
        this._gl.glTranslatef(x, y, 0.0f);
    }

    public void translate(float x, float y, float z) {
        this._gl.glTranslatef(x, y, z);
    }

    public void translate(Vector3 v) {
        this._gl.glTranslatef(v.x, v.y, v.z);
    }

    public void translate(Vector4 v) {
        this._gl.glTranslatef(v.x, v.y, v.z);
    }

    public void rotate(float a) {
        this._gl.glRotatef(a, 1.0f, 1.0f, 1.0f);
    }

    public void rotate(float a, float x, float y, float z) {
        this._gl.glRotatef(a, x, y, z);
    }

    public void rotate(float a, Vector3 v) {
        this._gl.glRotatef(a, v.x, v.y, v.z);
    }

    public void rotate(Vector4 v) {
        this._gl.glRotatef(v.w, v.x, v.y, v.z);
    }

    public void rotateX(float a) {
        this._gl.glRotatef(a, 1.0f, 0.0f, 0.0f);
    }

    public void rotateY(float a) {
        this._gl.glRotatef(a, 0.0f, 1.0f, 0.0f);
    }

    public void rotateZ(float a) {
        this._gl.glRotatef(a, 0.0f, 0.0f, 1.0f);
    }

    public void scale(float sx, float sy, float sz) {
        this._gl.glScalef(sx, sy, sz);
    }

    public void scale(float s) {
        this._gl.glScalef(s, s, s);
    }

    public void loadMatrix(DoubleBuffer m) {
        this._gl.glLoadMatrixd(m);
    }

    public void loadMatrix(FloatBuffer m) {
        this._gl.glLoadMatrixf(m);
    }

    public void loadMatrix(Matrix m) {
        this._gl.glLoadMatrixf(m.getFloatBuffer());
    }

    public void multMatrix(DoubleBuffer m) {
        this._gl.glMultMatrixd(m);
    }

    public void multMatrix(FloatBuffer m) {
        this._gl.glMultMatrixf(m);
    }

    public void multMatrix(Matrix m) {
        FloatBuffer fb = FloatBuffer.wrap(m._M);
        this._gl.glMultMatrixf(fb);
    }

    public void pushMatrix() {
        this._gl.glPushMatrix();
    }

    public void popMatrix() {
        this._gl.glPopMatrix();
    }

    public void enableBlend() {
        this._gl.glEnable(3042);
    }

    public void disableBlend() {
        this._gl.glDisable(3042);
    }

    public void setBlend(boolean f) {
        if (f) {
            this._gl.glEnable(3042);
        } else {
            this._gl.glDisable(3042);
        }
    }

    public void setBlendEquation(int method) {
        switch (method) {
            case 0: {
                this._gl.glBlendEquation(32774);
                break;
            }
            case 1: {
                this._gl.glBlendEquation(32778);
                break;
            }
            case 2: {
                this._gl.glBlendEquation(32779);
            }
        }
    }

    public void setBlendEquationSeperate(int methodRGB, int methodAlpha) {
        this._gl.glBlendEquationSeparate(methodRGB, methodAlpha);
    }

    public void setAlphaBlend() {
        this._gl.glBlendFunc(770, 771);
    }

    public void setAdditiveBlend() {
        this._gl.glBlendFunc(770, 1);
    }

    public void setOneBlend() {
        this._gl.glBlendFunc(1, 1);
    }

    public void setOneZeroBlend() {
        this._gl.glBlendFunc(1, 0);
    }

    public void enableLighting(boolean f) {
        if (f) {
            this._gl.glEnable(2896);
        } else {
            this._gl.glDisable(2896);
        }
    }

    public void enableTexture(boolean f) {
        if (f) {
            this._gl.glEnable(3553);
        } else {
            this._gl.glDisable(3553);
        }
    }

    public void enableTexture(boolean f, int texType) {
        switch (texType) {
            case 1: 
            case 3553: {
                if (f) {
                    this._gl.glEnable(3553);
                    break;
                }
                this._gl.glDisable(3553);
                break;
            }
            case 2: 
            case 34037: {
                if (f) {
                    this._gl.glEnable(34037);
                    break;
                }
                this._gl.glDisable(34037);
                break;
            }
            default: {
                if (f) {
                    this._gl.glEnable(3553);
                    break;
                }
                this._gl.glDisable(3553);
            }
        }
    }

    public void setDepthWrite(boolean f) {
        if (f) {
            this._gl.glEnable(2929);
        } else {
            this._gl.glDisable(2929);
        }
    }

    public void setDepthMask(boolean f) {
        this._gl.glDepthMask(f);
    }

    public void resetToDefaults() {
        this._gl.glBlendFunc(1, 0);
        this._gl.glBlendEquation(32774);
        this._gl.glEnable(3042);
        this._gl.glEnable(2929);
        this._gl.glDepthMask(true);
        this._gl.glDisable(2896);
        this.disableShader();
    }

    public void fill(float c) {
        this._r = c;
        this._g = c;
        this._b = c;
        this._a = 1.0f;
    }

    public void fill(float c, float a) {
        this._r = c;
        this._g = c;
        this._b = c;
        this._a = a;
    }

    public void fill(float r, float g, float b) {
        this._r = r;
        this._g = g;
        this._b = b;
        this._a = 1.0f;
    }

    public void fill(float r, float g, float b, float a) {
        this._r = r;
        this._g = g;
        this._b = b;
        this._a = a;
    }

    public void quad(float posx, float posy, float z, float s) {
        this._gl.glBegin(7);
        this._gl.glColor4f(this._r, this._g, this._b, this._a);
        this._gl.glNormal3f(0.0f, 0.0f, 1.0f);
        this._gl.glTexCoord2f(0.0f * this._uScale, 0.0f * this._vScale);
        this._gl.glVertex3f(posx + -1.0f * s, posy + 1.0f * s, z);
        this._gl.glColor4f(this._r, this._g, this._b, this._a);
        this._gl.glNormal3f(0.0f, 0.0f, 1.0f);
        this._gl.glTexCoord2f(1.0f * this._uScale, 0.0f * this._vScale);
        this._gl.glVertex3f(posx + 1.0f * s, posy + 1.0f * s, z);
        this._gl.glColor4f(this._r, this._g, this._b, this._a);
        this._gl.glNormal3f(0.0f, 0.0f, 1.0f);
        this._gl.glTexCoord2f(1.0f * this._uScale, 1.0f * this._vScale);
        this._gl.glVertex3f(posx + 1.0f * s, posy + -1.0f * s, z);
        this._gl.glColor4f(this._r, this._g, this._b, this._a);
        this._gl.glNormal3f(0.0f, 0.0f, 1.0f);
        this._gl.glTexCoord2f(0.0f * this._uScale, 1.0f * this._vScale);
        this._gl.glVertex3f(posx + -1.0f * s, posy + -1.0f * s, z);
        this._gl.glEnd();
    }

    public void quad(float s) {
        this.quad(0.0f, 0.0f, 0.0f, s);
    }

    public void rect(float posx, float posy, float z, float sx, float sy) {
        if (this._flipV) {
            this._gl.glBegin(7);
            this._gl.glColor4f(this._r, this._g, this._b, this._a);
            this._gl.glNormal3f(0.0f, 0.0f, 1.0f);
            this._gl.glTexCoord2f(0.0f * this._uScale + this._uOffset, 1.0f * this._vScale + this._vOffset * -1.0f);
            this._gl.glVertex3f(posx + -1.0f * sx, posy + -1.0f * sy, z);
            this._gl.glColor4f(this._r, this._g, this._b, this._a);
            this._gl.glNormal3f(0.0f, 0.0f, 1.0f);
            this._gl.glTexCoord2f(1.0f * this._uScale + this._uOffset, 1.0f * this._vScale + this._vOffset * -1.0f);
            this._gl.glVertex3f(posx + 1.0f * sx, posy + -1.0f * sy, z);
            this._gl.glColor4f(this._r, this._g, this._b, this._a);
            this._gl.glNormal3f(0.0f, 0.0f, 1.0f);
            this._gl.glTexCoord2f(1.0f * this._uScale + this._uOffset, 0.0f * this._vScale + this._vOffset * -1.0f);
            this._gl.glVertex3f(posx + 1.0f * sx, posy + 1.0f * sy, z);
            this._gl.glColor4f(this._r, this._g, this._b, this._a);
            this._gl.glNormal3f(0.0f, 0.0f, 1.0f);
            this._gl.glTexCoord2f(0.0f * this._uScale + this._uOffset, 0.0f * this._vScale + this._vOffset);
            this._gl.glVertex3f(posx + -1.0f * sx, posy + 1.0f * sy, z);
            this._gl.glEnd();
        } else {
            this._gl.glBegin(7);
            this._gl.glColor4f(this._r, this._g, this._b, this._a);
            this._gl.glNormal3f(0.0f, 0.0f, 1.0f);
            this._gl.glTexCoord2f(0.0f * this._uScale + this._uOffset, 0.0f * this._vScale + this._vOffset);
            this._gl.glVertex3f(posx + -1.0f * sx, posy + -1.0f * sy, z);
            this._gl.glColor4f(this._r, this._g, this._b, this._a);
            this._gl.glNormal3f(0.0f, 0.0f, 1.0f);
            this._gl.glTexCoord2f(1.0f * this._uScale + this._uOffset, 0.0f * this._vScale + this._vOffset);
            this._gl.glVertex3f(posx + 1.0f * sx, posy + -1.0f * sy, z);
            this._gl.glColor4f(this._r, this._g, this._b, this._a);
            this._gl.glNormal3f(0.0f, 0.0f, 1.0f);
            this._gl.glTexCoord2f(1.0f * this._uScale + this._uOffset, 1.0f * this._vScale + this._vOffset);
            this._gl.glVertex3f(posx + 1.0f * sx, posy + 1.0f * sy, z);
            this._gl.glColor4f(this._r, this._g, this._b, this._a);
            this._gl.glNormal3f(0.0f, 0.0f, 1.0f);
            this._gl.glTexCoord2f(0.0f * this._uScale + this._uOffset, 1.0f * this._vScale + this._vOffset);
            this._gl.glVertex3f(posx + -1.0f * sx, posy + 1.0f * sy, z);
            this._gl.glEnd();
        }
    }

    public void rect(float posx, float posy, float sx, float sy) {
        this._gl.glBegin(7);
        this._gl.glNormal3f(0.0f, 0.0f, 1.0f);
        this._gl.glColor4f(this._r, this._g, this._b, this._a);
        this._gl.glTexCoord2f(0.0f * this._uScale, 0.0f * this._vScale);
        this._gl.glVertex3f(posx + 0.0f * sx, posy + 0.0f * sy, 0.0f);
        this._gl.glColor4f(this._r, this._g, this._b, this._a);
        this._gl.glTexCoord2f(1.0f * this._uScale, 0.0f * this._vScale);
        this._gl.glVertex3f(posx + 1.0f * sx, posy + 0.0f * sy, 0.0f);
        this._gl.glColor4f(this._r, this._g, this._b, this._a);
        this._gl.glTexCoord2f(1.0f * this._uScale, 1.0f * this._vScale);
        this._gl.glVertex3f(posx + 1.0f * sx, posy + 1.0f * sy, 0.0f);
        this._gl.glColor4f(this._r, this._g, this._b, this._a);
        this._gl.glTexCoord2f(0.0f * this._uScale, 1.0f * this._vScale);
        this._gl.glVertex3f(posx + 0.0f * sx, posy + 1.0f * sy, 0.0f);
        this._gl.glEnd();
    }

    public void rect(float sx, float sy) {
        this.rect(0.0f, 0.0f, 0.0f, sx, sy);
    }

    public void rectXZ(float posx, float posy, float posz, float sx, float sz) {
        if (this._flipV) {
            this._gl.glBegin(7);
            this._gl.glColor4f(this._r, this._g, this._b, this._a);
            this._gl.glNormal3f(0.0f, 1.0f, 0.0f);
            this._gl.glMultiTexCoord3f(33985, 1.0f, 0.0f, 0.0f);
            this._gl.glTexCoord2f(0.0f * this._uScale + this._uOffset, 1.0f * this._vScale + this._vOffset * -1.0f);
            this._gl.glVertex3f(posx + -1.0f * sx, posy, posz + -1.0f * sz);
            this._gl.glNormal3f(0.0f, 1.0f, 0.0f);
            this._gl.glMultiTexCoord3f(33985, 1.0f, 0.0f, 0.0f);
            this._gl.glTexCoord2f(1.0f * this._uScale + this._uOffset, 1.0f * this._vScale + this._vOffset * -1.0f);
            this._gl.glVertex3f(posx + 1.0f * sx, posy, posy + -1.0f * sz);
            this._gl.glNormal3f(0.0f, 1.0f, 0.0f);
            this._gl.glMultiTexCoord3f(33985, 1.0f, 0.0f, 0.0f);
            this._gl.glTexCoord2f(1.0f * this._uScale + this._uOffset, 0.0f * this._vScale + this._vOffset * -1.0f);
            this._gl.glVertex3f(posx + 1.0f * sx, posy, posy + 1.0f * sz);
            this._gl.glNormal3f(0.0f, 1.0f, 0.0f);
            this._gl.glMultiTexCoord3f(33985, 1.0f, 0.0f, 0.0f);
            this._gl.glTexCoord2f(0.0f * this._uScale + this._uOffset, 0.0f * this._vScale + this._vOffset);
            this._gl.glVertex3f(posx + -1.0f * sx, posy, posy + 1.0f * sz);
            this._gl.glEnd();
        } else {
            this._gl.glBegin(7);
            this._gl.glColor4f(this._r, this._g, this._b, this._a);
            this._gl.glNormal3f(0.0f, 1.0f, 0.0f);
            this._gl.glMultiTexCoord3f(33985, 1.0f, 0.0f, 0.0f);
            this._gl.glTexCoord2f(0.0f * this._uScale + this._uOffset, 0.0f * this._vScale + this._vOffset);
            this._gl.glVertex3f(posx + -1.0f * sx, posy, posy + -1.0f * sz);
            this._gl.glNormal3f(0.0f, 1.0f, 0.0f);
            this._gl.glMultiTexCoord3f(33985, 1.0f, 0.0f, 0.0f);
            this._gl.glTexCoord2f(1.0f * this._uScale + this._uOffset, 0.0f * this._vScale + this._vOffset);
            this._gl.glVertex3f(posx + 1.0f * sx, posy, posy + -1.0f * sz);
            this._gl.glNormal3f(0.0f, 1.0f, 0.0f);
            this._gl.glMultiTexCoord3f(33985, 1.0f, 0.0f, 0.0f);
            this._gl.glTexCoord2f(1.0f * this._uScale + this._uOffset, 1.0f * this._vScale + this._vOffset);
            this._gl.glVertex3f(posx + 1.0f * sx, posy, posy + 1.0f * sz);
            this._gl.glNormal3f(0.0f, 1.0f, 0.0f);
            this._gl.glTexCoord2f(0.0f * this._uScale + this._uOffset, 1.0f * this._vScale + this._vOffset);
            this._gl.glMultiTexCoord3f(33985, 1.0f, 0.0f, 0.0f);
            this._gl.glVertex3f(posx + -1.0f * sx, posy, posz + 1.0f * sz);
            this._gl.glEnd();
        }
    }

    public void rectXZ(float sx, float sy) {
        this.rectXZ(0.0f, 0.0f, 0.0f, sx, sy);
    }

    public void rectTopLeft(float posx, float posy, float z, float sx, float sy) {
        if (this._flipV) {
            this._gl.glBegin(7);
            this._gl.glColor4f(this._r, this._g, this._b, this._a);
            this._gl.glNormal3f(0.0f, 0.0f, 1.0f);
            this._gl.glTexCoord2f(0.0f * this._uScale + this._uOffset, 1.0f * this._vScale + this._vOffset * -1.0f);
            this._gl.glVertex3f(posx + 0.0f * sx, posy + 0.0f * sy, z);
            this._gl.glColor4f(this._r, this._g, this._b, this._a);
            this._gl.glNormal3f(0.0f, 0.0f, 1.0f);
            this._gl.glTexCoord2f(1.0f * this._uScale + this._uOffset, 1.0f * this._vScale + this._vOffset * -1.0f);
            this._gl.glVertex3f(posx + 1.0f * sx, posy + 0.0f * sy, z);
            this._gl.glColor4f(this._r, this._g, this._b, this._a);
            this._gl.glNormal3f(0.0f, 0.0f, 1.0f);
            this._gl.glTexCoord2f(1.0f * this._uScale + this._uOffset, 0.0f * this._vScale + this._vOffset * -1.0f);
            this._gl.glVertex3f(posx + 1.0f * sx, posy + 1.0f * sy, z);
            this._gl.glColor4f(this._r, this._g, this._b, this._a);
            this._gl.glNormal3f(0.0f, 0.0f, 1.0f);
            this._gl.glTexCoord2f(0.0f * this._uScale + this._uOffset, 0.0f * this._vScale + this._vOffset);
            this._gl.glVertex3f(posx + 0.0f * sx, posy + 1.0f * sy, z);
            this._gl.glEnd();
        } else {
            this._gl.glBegin(7);
            this._gl.glColor4f(this._r, this._g, this._b, this._a);
            this._gl.glNormal3f(0.0f, 0.0f, 1.0f);
            this._gl.glTexCoord2f(0.0f * this._uScale + this._uOffset, 0.0f * this._vScale + this._vOffset);
            this._gl.glVertex3f(posx + 0.0f * sx, posy + 0.0f * sy, z);
            this._gl.glColor4f(this._r, this._g, this._b, this._a);
            this._gl.glNormal3f(0.0f, 0.0f, 1.0f);
            this._gl.glTexCoord2f(1.0f * this._uScale + this._uOffset, 0.0f * this._vScale + this._vOffset);
            this._gl.glVertex3f(posx + 1.0f * sx, posy + 0.0f * sy, z);
            this._gl.glColor4f(this._r, this._g, this._b, this._a);
            this._gl.glNormal3f(0.0f, 0.0f, 1.0f);
            this._gl.glTexCoord2f(1.0f * this._uScale + this._uOffset, 1.0f * this._vScale + this._vOffset);
            this._gl.glVertex3f(posx + 1.0f * sx, posy + 1.0f * sy, z);
            this._gl.glColor4f(this._r, this._g, this._b, this._a);
            this._gl.glNormal3f(0.0f, 0.0f, 1.0f);
            this._gl.glTexCoord2f(0.0f * this._uScale + this._uOffset, 1.0f * this._vScale + this._vOffset);
            this._gl.glVertex3f(posx + 0.0f * sx, posy + 1.0f * sy, z);
            this._gl.glEnd();
        }
    }

    public void rectTopLeft(float sx, float sy) {
        this.rectTopLeft(0.0f, 0.0f, 0.0f, sx, sy);
    }

    public void ellipse(float sx, float sy) {
        this.ellipse(0.0f, 0.0f, 0.0f, sx, sy);
    }

    public void ellipse(float posx, float posy, float posz, float sx, float sy) {
        this.ellipse(posx, posy, posz, sx, sy, 20);
    }

    public void ellipse(float posx, float posy, float posz, float sx, float sy, int detail) {
        float invDetail = 1.0f / (float)detail;
        this._gl.glBegin(6);
        this._gl.glColor4f(this._r, this._g, this._b, this._a);
        int i = 0;
        while (i < detail) {
            float per = (float)i * invDetail;
            float x = (float)Math.cos((double)(per * 2.0f) * Math.PI);
            float y = (float)Math.sin((double)(per * 2.0f) * Math.PI);
            float u = 0.5f + x * 0.5f;
            float v = 0.5f + y * 0.5f;
            this._gl.glNormal3f(0.0f, 0.0f, 1.0f);
            this._gl.glTexCoord2f(u * this._uScale + this._uOffset, (1.0f - v) * this._vScale + this._vOffset * -1.0f);
            this._gl.glVertex3f(posx + x * sx, posy + y * sy, posz);
            ++i;
        }
        this._gl.glEnd();
    }

    public void drawGrid(float x, float y, float z, float wid, float hei, int xCells, int yCells) {
        this.drawGrid(x, y, z, wid, hei, xCells, yCells, false);
    }

    public void drawGrid(float x, float y, float z, float wid, float hei, int xCells, int yCells, boolean flipNormals) {
        Vector3 p1 = new Vector3();
        Vector3 p2 = new Vector3();
        float xstep = wid / (float)xCells;
        float ystep = hei / (float)yCells;
        float invXCells = 1.0f / (float)xCells;
        float invYCells = 1.0f / (float)yCells;
        int j = 0;
        while (j < yCells - 1) {
            this._gl.glBegin(5);
            int i = 0;
            while (i < xCells) {
                p1.set(x + (float)i * xstep - wid * 0.5f, y + (float)j * ystep - hei * 0.5f, z);
                p2.set(x + (float)i * xstep - wid * 0.5f, y + (float)(j + 1) * ystep - hei * 0.5f, z);
                float u = (float)i * invXCells * this._uScale + this._uOffset;
                float v1 = (float)j * invYCells * this._vScale + this._vOffset;
                float v2 = (float)(j + 1) * invYCells * this._vScale + this._vOffset;
                this._gl.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
                if (flipNormals) {
                    this._gl.glNormal3f(0.0f, 0.0f, -1.0f);
                } else {
                    this._gl.glNormal3f(0.0f, 0.0f, 1.0f);
                }
                this._gl.glTexCoord2f(u, v1);
                this._gl.glVertex3f(p1.x, p1.y, p1.z);
                this._gl.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
                if (flipNormals) {
                    this._gl.glNormal3f(0.0f, 0.0f, -1.0f);
                } else {
                    this._gl.glNormal3f(0.0f, 0.0f, 1.0f);
                }
                this._gl.glTexCoord2f(u, v2);
                this._gl.glVertex3f(p2.x, p2.y, p2.z);
                ++i;
            }
            this._gl.glEnd();
            ++j;
        }
    }

    public void drawGridXZ(float x, float y, float z, float wid, float hei, int xCells, int zCells) {
        Vector3 p1 = new Vector3();
        Vector3 p2 = new Vector3();
        float xstep = wid / (float)xCells;
        float zstep = hei / (float)zCells;
        float invXCells = 1.0f / (float)xCells;
        float invZCells = 1.0f / (float)zCells;
        int j = 0;
        while (j < zCells - 1) {
            this._gl.glBegin(5);
            int i = 0;
            while (i < xCells) {
                p1.set(x + (float)i * xstep - wid * 0.5f, y, z + (float)j * zstep - hei * 0.5f);
                p2.set(x + (float)i * xstep - wid * 0.5f, y, z + (float)(j + 1) * zstep - hei * 0.5f);
                float u = (float)i * invXCells * this._uScale + this._uOffset;
                float v1 = (float)j * invZCells * this._vScale + this._vOffset;
                float v2 = (float)(j + 1) * invZCells * this._vScale + this._vOffset;
                this._gl.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
                this._gl.glNormal3f(0.0f, 1.0f, 0.0f);
                this._gl.glMultiTexCoord3f(33985, 1.0f, 0.0f, 0.0f);
                this._gl.glTexCoord2f(u, v1);
                this._gl.glVertex3f(p1.x, p1.y, p1.z);
                this._gl.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
                this._gl.glNormal3f(0.0f, 1.0f, 0.0f);
                this._gl.glMultiTexCoord3f(33985, 1.0f, 0.0f, 0.0f);
                this._gl.glTexCoord2f(u, v2);
                this._gl.glVertex3f(p2.x, p2.y, p2.z);
                ++i;
            }
            this._gl.glEnd();
            ++j;
        }
    }

    public void texCoordScale(float uScale, float vScale) {
        this._uScale = uScale;
        this._vScale = vScale;
    }

    public void texCoordOffset(float uo, float vo) {
        this._uOffset = uo;
        this._vOffset = vo;
    }

    public void line(Vector3 p1, Vector3 p2) {
        this._gl.glBegin(1);
        this._gl.glColor4f(this._r, this._g, this._b, this._a);
        this._gl.glVertex3f(p1.x, p1.y, p1.z);
        this._gl.glVertex3f(p2.x, p2.y, p2.z);
        this._gl.glEnd();
    }

    public void line(Vector3 p1, Vector3 p2, float i1, float i2) {
        this._gl.glBegin(1);
        this._gl.glColor4f(i1, i1, i1, i1);
        this._gl.glVertex3f(p1.x, p1.y, p1.z);
        this._gl.glColor4f(i2, i2, i2, i2);
        this._gl.glVertex3f(p2.x, p2.y, p2.z);
        this._gl.glEnd();
    }

    public void line(Vector3 p1, Vector3 p2, float r1, float g1, float b1, float a1, float r2, float g2, float b2, float a2) {
        this._gl.glBegin(1);
        this._gl.glColor4f(r1, g1, b1, a1);
        this._gl.glVertex3f(p1.x, p1.y, p1.z);
        this._gl.glColor4f(r2, g2, b2, a2);
        this._gl.glVertex3f(p2.x, p2.y, p2.z);
        this._gl.glEnd();
    }

    public void line(Vector3 p1, Vector3 p2, Vector4 col1, Vector4 col2) {
        this._gl.glBegin(1);
        this._gl.glColor4f(col1.x, col1.y, col1.z, col1.w);
        this._gl.glVertex3f(p1.x, p1.y, p1.z);
        this._gl.glColor4f(col2.x, col2.y, col2.z, col2.w);
        this._gl.glVertex3f(p2.x, p2.y, p2.z);
        this._gl.glEnd();
    }

    public void line(float p1x, float p1y, float p1z, float p2x, float p2y, float p2z) {
        this._gl.glBegin(1);
        this._gl.glColor4f(this._r, this._g, this._b, this._a);
        this._gl.glVertex3f(p1x, p1y, p1z);
        this._gl.glVertex3f(p2x, p2y, p2z);
        this._gl.glEnd();
    }

    public void beginShape(int ft) {
        switch (ft) {
            case 0: {
                this._gl.glBegin(0);
                break;
            }
            case 1: {
                this._gl.glBegin(1);
                break;
            }
            case 2: {
                this._gl.glBegin(4);
                break;
            }
            case 3: {
                this._gl.glBegin(7);
                break;
            }
            case 4: {
                this._gl.glBegin(3);
                break;
            }
            case 5: {
                this._gl.glBegin(5);
                break;
            }
            case 6: {
                this._gl.glBegin(8);
                break;
            }
            default: {
                this._gl.glBegin(0);
            }
        }
        this._gl.glColor4f(this._r, this._g, this._b, this._a);
    }

    public void endShape() {
        this._gl.glEnd();
    }

    public void vertex(float x, float y, float z) {
        this._gl.glVertex3f(x, y, z);
    }

    public void vertex(Vector3 v) {
        this._gl.glVertex3f(v.x, v.y, v.z);
    }

    public void texcoord(float u, float v) {
        this._gl.glTexCoord2f(u, v);
    }

    public void texcoord(float u, float v, float w) {
        this._gl.glTexCoord3f(u, v, w);
    }

    public void color1(float brightness) {
        this._gl.glColor4f(brightness, brightness, brightness, 1.0f);
    }

    public void color3(float r, float g, float b) {
        this._gl.glColor4f(r, g, b, 1.0f);
    }

    public void color4(float r, float g, float b, float a) {
        this._gl.glColor4f(r, g, b, a);
    }

    public boolean isvSyncEnabled() {
        return this.vSyncEnabled;
    }

    public void setVSync(boolean val) {
        this.vSyncEnabled = val;
        int flag = 1;
        if (!val) {
            flag = 0;
        }
        this._gl.setSwapInterval(flag);
    }

    public int addEffectFromFile(String effectFilename) {
        return this._shaderMan.addEffect(effectFilename, effectFilename);
    }

    public int addShaderFromFile(String vfile, String ffile) {
        return this._shaderMan.addShader(vfile, vfile, ffile);
    }

    public void setShader(int idx) {
        this._shaderMan.enable(idx);
    }

    public void enableShader(int idx) {
        this._shaderMan.enable(idx);
    }

    public void disableShader() {
        this._shaderMan.disable();
    }

    public void setTextureParameter(String param, int val) {
        if (this._shaderMan.getActiveShader() != null) {
            this._shaderMan.getActiveShader().setTextureParameter(param, val);
        }
    }

    public void setParameter1i(String param, int val) {
        if (this._shaderMan.getActiveShader() != null) {
            this._shaderMan.getActiveShader().setParameter1i(param, val);
        }
    }

    public void setParameter1f(String param, float val) {
        if (this._shaderMan.getActiveShader() != null) {
            this._shaderMan.getActiveShader().setParameter1f(param, val);
        }
    }

    public void setParameter2f(String param, float x, float y) {
        if (this._shaderMan.getActiveShader() != null) {
            this._shaderMan.getActiveShader().setParameter2f(param, x, y);
        }
    }

    public void setParameter2i(String param, int x, int y) {
        if (this._shaderMan.getActiveShader() != null) {
            this._shaderMan.getActiveShader().setParameter2i(param, x, y);
        }
    }

    public void setParameter3f(String param, float x, float y, float z) {
        if (this._shaderMan.getActiveShader() != null) {
            this._shaderMan.getActiveShader().setParameter3f(param, x, y, z);
        }
    }

    public void setParameter3f(String param, Vector3 v) {
        if (this._shaderMan.getActiveShader() != null) {
            this._shaderMan.getActiveShader().setParameter3f(param, v.x, v.y, v.z);
        }
    }

    public void setParameter3fv(String param, float[] v) {
        if (this._shaderMan.getActiveShader() != null) {
            this._shaderMan.getActiveShader().setParameter3fv(param, v);
        }
    }

    public void setParameter4f(String param, float x, float y, float z, float w) {
        if (this._shaderMan.getActiveShader() != null) {
            this._shaderMan.getActiveShader().setParameter4f(param, x, y, z, w);
        }
    }

    public void setParameter4f(String param, Vector4 v) {
        if (this._shaderMan.getActiveShader() != null) {
            this._shaderMan.getActiveShader().setParameter4f(param, v.x, v.y, v.z, v.w);
        }
    }

    public void setParameter4fv(String param, float[] v) {
        if (this._shaderMan.getActiveShader() != null) {
            this._shaderMan.getActiveShader().setParameter4fv(param, v);
        }
    }

    public void setParameter1fv(String param, float[] v) {
        if (this._shaderMan.getActiveShader() != null) {
            this._shaderMan.getActiveShader().setParameter1fv(param, v);
        }
    }

    public void setParameter3fv(String param, Vector3[] v) {
        float[] vv = new float[v.length * 3];
        int index = 0;
        int i = 0;
        while (i < v.length) {
            vv[index + 0] = v[i].x;
            vv[index + 1] = v[i].y;
            vv[index + 2] = v[i].z;
            index += 3;
            ++i;
        }
        if (this._shaderMan.getActiveShader() != null) {
            this._shaderMan.getActiveShader().setParameter3fv(param, vv);
        }
    }

    public void setParameter4fv(String param, Vector4[] v) {
        float[] vv = new float[v.length * 4];
        int index = 0;
        int i = 0;
        while (i < v.length) {
            vv[index + 0] = v[i].x;
            vv[index + 1] = v[i].y;
            vv[index + 2] = v[i].z;
            vv[index + 3] = v[i].w;
            index += 4;
            ++i;
        }
        if (this._shaderMan.getActiveShader() != null) {
            this._shaderMan.getActiveShader().setParameter4fv(param, vv);
        }
    }

    public void setParameter4x4fBySemantic(String param, int matrix, int matrixType) {
        if (this._shaderMan.getActiveShader() != null) {
            this._shaderMan.setMatrixParameterSemantic(param, matrix, matrixType);
        }
    }

    public void setMatrixParameterSemantic(String param, int matrix, int matrixType) {
        if (this._shaderMan.getActiveShader() != null) {
            this._shaderMan.setMatrixParameterSemantic(param, matrix, matrixType);
        }
    }

    public void setMatrixParameterSemantic(String param, float[] v) {
        if (this._shaderMan.getActiveShader() != null) {
            this._shaderMan.setMatrixParameterSemantic(param, v);
        }
    }

    public void setParameter4x4f(String param, int matrix, int matrixType) {
        if (this._shaderMan.getActiveShader() != null) {
            this._shaderMan.setParameter4x4f(param, matrix, matrixType);
        }
    }

    public void setParameter4x4f(String param, Matrix m) {
        if (this._shaderMan.getActiveShader() != null) {
            this._shaderMan.getActiveShader().setParameter4x4f(param, m.getArray());
        }
    }

    public Shader getActiveShader() {
        return this._shaderMan.getActiveShader();
    }

    public ShaderCGFX getActiveEffect() {
        return this._shaderMan.getActiveEffect();
    }

    public void enableTexture(int idx) {
        VTexture tex = null;
        if (idx < 0) {
            return;
        }
        tex = this._texturePool.get(idx);
        this._gl.glEnable(3553);
        if (tex != null) {
            tex.enable();
        }
    }

    public void disableTexture() {
        this._gl.glDisable(3553);
        this._gl.glBindTexture(3553, 0);
    }

    public int loadTexture(String filename) {
        if (this._texturePool == null) {
            this._texturePool = new HashMap<Integer, VTexture>();
        }
        VTexture2D tex = new VTexture2D(this._gl);
        tex.loadFromFile(VStringUtils.dataPath(filename), true, null);
        try {
            this._texturePool.put(this._numTextures, tex);
            int texID = this._numTextures++;
            return texID;
        }
        catch (Exception e) {
            System.err.println("(VGL)  Failed to create texture: " + filename);
            return 0;
        }
    }

    public int createRenderTarget(int target, int w, int h, int format, VSamplerState sampler) {
        if (this._texturePool == null) {
            this._texturePool = new HashMap<Integer, VTexture>();
        }
        VTexture tex = new VTexture(this._gl, target);
        tex.create(target, w, h, format, sampler);
        try {
            this._texturePool.put(this._numTextures, tex);
            int texID = this._numTextures++;
            return texID;
        }
        catch (Exception e) {
            System.err.println("(VGL) Failed to create texture!");
            return 0;
        }
    }

    public int createRenderDepth(int w, int h, int format, VSamplerState sampler) {
        if (this._texturePool == null) {
            this._texturePool = new HashMap<Integer, VTexture>();
        }
        VTexture tex = new VTexture(this._gl, 36161);
        tex.createDepthRT(w, h, format);
        try {
            this._texturePool.put(this._numTextures, tex);
            int texID = this._numTextures++;
            return texID;
        }
        catch (Exception e) {
            System.err.println("(VGL) Failed to create texture!");
            return 0;
        }
    }

    public int addTexture(int targetID, String filename) {
        if (this._texturePool == null || this._texturePool.size() <= 0) {
            this._texturePool = new HashMap<Integer, VTexture>();
        }
        VTexture tex = null;
        tex = this._useProcessing ? new VTexture(this._gl, targetID, this._parent.dataPath(filename)) : new VTexture(this._gl, targetID, VStringUtils.dataPath(filename));
        try {
            this._texturePool.put(this._numTextures, tex);
            int texID = this._numTextures++;
            return texID;
        }
        catch (Exception e) {
            System.err.println("(VGL) Failed to load texture: " + filename);
            return 0;
        }
    }

    public void removeTexture(int texid) {
        VTexture tex = this._texturePool.get(texid);
        if (tex._targetID != 0) {
            if (tex._targetID == 36161) {
                int[] tmp = new int[]{tex.getId()};
                this._gl.glDeleteRenderbuffersEXT(1, tmp, 0);
            } else {
                int[] tmp = new int[]{tex.getId()};
                this._gl.glDeleteTextures(1, tmp, 0);
            }
            tex._id = 0;
        }
    }

    public int[] readPixels(int x, int y, int width, int height) {
        return this.readPixels(x, y, width, height, 1029);
    }

    public int[] readPixels(int x, int y, int width, int height, int readBuffer) {
        int[] pixels = new int[width * height];
        this._gl.glReadBuffer(readBuffer);
        this._gl.glPixelStorei(3333, 1);
        this._gl.glReadPixels(x, y, width, height, 32993, 5121, (Buffer)IntBuffer.wrap(pixels));
        return pixels;
    }

    public Scene loadScene(String filename) {
        return this.loadScene(filename, false);
    }

    public Scene loadScene(String filename, boolean swapYZ) {
        if (filename == null) {
            System.out.println("(VGL) Scene filename is null. Try with a real filename");
            return null;
        }
        String[] ext = filename.split("\\.");
        if (ext[ext.length - 1].equals("3ds")) {
            System.err.println("(VGL)  3ds file format is not supported.");
            return null;
        }
        if (ext[ext.length - 1].equals("mm")) {
            MMLoader mm = null;
            mm = new MMLoader(this._gl);
            Scene scene = new Scene(this._parent, this._gl);
            boolean res = mm.load(filename, scene, swapYZ);
            if (!res) {
                return null;
            }
            return scene;
        }
        return null;
    }

    public void release() {
        if (this._texturePool != null) {
            int i = 0;
            while (i < this._texturePool.size()) {
                VTexture t = this._texturePool.get(i);
                t.release();
                ++i;
            }
            this._texturePool.clear();
            this._texturePool = null;
        }
        if (this._shaderMan != null) {
            this._shaderMan.release();
            this._shaderMan = null;
        }
        this._extensions = null;
        this._parent = null;
        this._gl = null;
        this._glu = null;
    }

    public String getExtensions() {
        return this._extensions.getExtensions();
    }

    public boolean checkExtension(String ext) {
        return this._extensions.checkExtension(ext);
    }

    public String checkExtensionList(String[] list) {
        String str = new String();
        System.out.println("-----------------------------");
        int i = 0;
        while (i < list.length) {
            boolean res = this.checkExtension(list[i]);
            if (res) {
                System.out.println("- " + list[i] + " is: \t*TRUE*");
            } else {
                System.err.println("- " + list[i] + " is: \t*FALSE*");
            }
            if (i == list.length - 1) {
                System.out.println("-----------------------------\n");
            }
            ++i;
        }
        return str;
    }

    public String checkMostCommonExtensions() {
        String[] extList = new String[]{"GL_ARB_fragment_program", "GL_ARB_fragment_shader", "GL_ARB_vertex_program", "GL_ARB_vertex_shader", "GL_ARB_geometry_shader4", "GL_EXT_gpu_shader4", "GL_ARB_transpose_matrix", "GL_ARB_texture_non_power_of_two", "GL_ARB_texture_rectangle", "GL_ARB_framebuffer_object", "GL_ARB_vertex_buffer_object", "GL_ARB_depth_texture", "GL_ARB_draw_buffers"};
        return this.checkExtensionList(extList);
    }

    public ShaderManager getShaderManager() {
        return this._shaderMan;
    }

    public PApplet getParent() {
        return this._parent;
    }

    public void setFlipV(boolean f) {
        this._flipV = f;
    }

    public boolean DEBUG() {
        return this._debugMode;
    }

    public int getWidth() {
        return this._width;
    }

    public int getHeight() {
        return this._height;
    }

    public static VGL getSingleton() {
        if (_singleton == null) {
            _singleton = new VGL();
        }
        return _singleton;
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }
}

