/*
 * Decompiled with CFR 0.152.
 */
package vitamin;

import com.sun.opengl.cg.CGcontext;
import com.sun.opengl.cg.CGeffect;
import com.sun.opengl.cg.CGparameter;
import com.sun.opengl.cg.CGpass;
import com.sun.opengl.cg.CGtechnique;
import com.sun.opengl.cg.CgGL;
import javax.media.opengl.GL;
import vitamin.Shader;
import vitamin.VLogger;

public class ShaderCGFX
extends Shader {
    CGcontext _context = null;
    CGeffect _effect;
    CGtechnique _currTechnique;
    CGpass _currPass;

    public ShaderCGFX(GL gl, String name) {
        this._gl = gl;
        this._type = 2;
        this._name = name;
        VLogger.getSingleton().log("create context");
        this._context = CgGL.cgCreateContext();
        this.checkCgError();
        int error = CgGL.cgGetError();
        VLogger.getSingleton().log("(ShaderCGFX)  " + CgGL.cgGetErrorString((int)error));
        VLogger.getSingleton().log("(ShaderCGFX)  " + CgGL.cgGetLastListing((CGcontext)this._context));
        VLogger.getSingleton().log("register context states");
        CgGL.cgGLRegisterStates((CGcontext)this._context);
        VLogger.getSingleton().log("set managed texture params");
        CgGL.cgGLSetManageTextureParameters((CGcontext)this._context, (boolean)true);
        VLogger.getSingleton().log("init cgfx shader");
    }

    private void checkCgError() {
        int err = CgGL.cgGetError();
        if (err != 0) {
            VLogger.getSingleton().log("CG error: " + CgGL.cgGetErrorString((int)err));
            throw new RuntimeException("CG error: " + CgGL.cgGetErrorString((int)err));
        }
    }

    public CGeffect getEffect() {
        return this._effect;
    }

    public void load(String file) {
        int error = 0;
        System.out.println("(ShaderCGFX)  Loading CGFX filename: " + file);
        this._effect = CgGL.cgCreateEffectFromFile((CGcontext)this._context, (String)file, null);
        error = CgGL.cgGetError();
        String errorString = CgGL.cgGetErrorString((int)error);
        String lastListingString = CgGL.cgGetLastListing((CGcontext)this._context);
        System.out.println("(ShaderCGFX)  " + errorString);
        if (lastListingString != null) {
            System.out.println("(ShaderCGFX)  " + lastListingString);
        }
        if (this._effect == null) {
            System.err.println("(ShaderCGFX)  Effect file '" + file + "' not loaded correctly");
            error = CgGL.cgGetError();
            System.err.println("(ShaderCGFX)  Error String: " + CgGL.cgGetErrorString((int)error));
            System.err.println("(ShaderCGFX)  Last Listing: " + CgGL.cgGetLastListing((CGcontext)this._context));
        }
        if (this.validate()) {
            System.err.println("'" + file + "' is not a validated effect! ");
            return;
        }
    }

    public boolean validate() {
        return CgGL.cgValidateTechnique((CGtechnique)this._currTechnique);
    }

    public void enable() {
    }

    public void disable() {
    }

    public void setFirstTechnique() {
        this._currTechnique = CgGL.cgGetFirstTechnique((CGeffect)this._effect);
        if (this._currTechnique == null) {
            System.err.println("(ShaderCGFX)  technique is null");
        }
        this._currPass = CgGL.cgGetFirstPass((CGtechnique)this._currTechnique);
    }

    public CGpass setTechnique(String name) {
        this._currTechnique = CgGL.cgGetNamedTechnique((CGeffect)this._effect, (String)name);
        if (this._currTechnique == null) {
            System.err.println("(ShaderCGFX)  technique '" + name + "' is null");
        }
        this._currPass = CgGL.cgGetFirstPass((CGtechnique)this._currTechnique);
        return this._currPass;
    }

    public CGpass setFirstPass() {
        this._currTechnique = CgGL.cgGetFirstTechnique((CGeffect)this._effect);
        if (this._currTechnique == null) {
            System.err.println("(ShaderCGFX)  first technique is null");
        }
        this._currPass = CgGL.cgGetFirstPass((CGtechnique)this._currTechnique);
        return this._currPass;
    }

    public CGpass setFirstPass(String name) {
        this._currTechnique = CgGL.cgGetNamedTechnique((CGeffect)this._effect, (String)name);
        if (this._currTechnique == null) {
            System.err.println("(ShaderCGFX)  technique '" + name + "' is null");
        }
        this._currPass = CgGL.cgGetFirstPass((CGtechnique)this._currTechnique);
        return this._currPass;
    }

    public CGpass setPass() {
        CgGL.cgSetPassState((CGpass)this._currPass);
        return this._currPass;
    }

    public CGpass nextPass() {
        this._currPass = CgGL.cgGetNextPass((CGpass)this._currPass);
        CgGL.cgSetPassState((CGpass)this._currPass);
        return this._currPass;
    }

    public void resetPass() {
        CgGL.cgResetPassState((CGpass)this._currPass);
    }

    public CGpass resetAndGetNextPass() {
        CgGL.cgResetPassState((CGpass)this._currPass);
        this._currPass = CgGL.cgGetNextPass((CGpass)this._currPass);
        CgGL.cgSetPassState((CGpass)this._currPass);
        return this._currPass;
    }

    public void setTextureParameter(String param, int val) {
        CGparameter p = null;
        p = CgGL.cgGetNamedEffectParameter((CGeffect)this._effect, (String)param);
        if (p != null) {
            CgGL.cgGLSetTextureParameter((CGparameter)p, (int)val);
        } else {
            System.err.println("(ShaderCGFX)  Cant find texture parameter");
        }
        CgGL.cgSetSamplerState((CGparameter)p);
    }

    public void setParameter1d(String param, double x) {
        CGparameter p = null;
        p = CgGL.cgGetNamedEffectParameter((CGeffect)this._effect, (String)param);
        if (p != null) {
            CgGL.cgSetParameter1d((CGparameter)p, (double)x);
        } else {
            System.err.println("(ShaderCGFX)  param1d is null");
        }
    }

    public void setParameter1f(String param, float x) {
        CGparameter p = null;
        p = CgGL.cgGetNamedEffectParameter((CGeffect)this._effect, (String)param);
        if (p != null) {
            CgGL.cgSetParameter1f((CGparameter)p, (float)x);
        } else {
            System.err.println("(ShaderCGFX)  param1f is null");
        }
    }

    public void setParameter1fv(String param, float[] v) {
        CGparameter p = null;
        p = CgGL.cgGetNamedEffectParameter((CGeffect)this._effect, (String)param);
        if (p != null) {
            CgGL.cgGLSetParameterArray1f((CGparameter)p, (long)0L, (long)v.length, (float[])v, (int)0);
        } else {
            System.err.println("(ShaderCGFX)  param1fv is null");
        }
    }

    public void setParameter1i(String param, int x) {
        CGparameter p = null;
        p = CgGL.cgGetNamedEffectParameter((CGeffect)this._effect, (String)param);
        if (p != null) {
            CgGL.cgSetParameter1i((CGparameter)p, (int)x);
        } else {
            System.err.println("(ShaderCGFX)  param1i is null");
        }
    }

    public void setParameter2f(String param, float x, float y) {
        CGparameter p = null;
        p = CgGL.cgGetNamedEffectParameter((CGeffect)this._effect, (String)param);
        if (p != null) {
            CgGL.cgSetParameter2f((CGparameter)p, (float)x, (float)y);
        } else {
            System.err.println("(ShaderCGFX)  param2f is null");
        }
    }

    public void setParameter2i(String param, int x, int y) {
        CGparameter p = null;
        p = CgGL.cgGetNamedEffectParameter((CGeffect)this._effect, (String)param);
        if (p != null) {
            CgGL.cgSetParameter2i((CGparameter)p, (int)x, (int)y);
        } else {
            System.err.println("(ShaderCGFX)  param2i is null");
        }
    }

    public void setParameter3f(String param, float x, float y, float z) {
        CGparameter p = null;
        p = CgGL.cgGetNamedEffectParameter((CGeffect)this._effect, (String)param);
        if (p != null) {
            CgGL.cgSetParameter3f((CGparameter)p, (float)x, (float)y, (float)z);
        } else {
            System.err.println("(ShaderCGFX)  param3f is null");
        }
    }

    public void setParameter3fv(String param, float[] v) {
        CGparameter p = null;
        p = CgGL.cgGetNamedEffectParameter((CGeffect)this._effect, (String)param);
        if (p != null) {
            CgGL.cgGLSetParameterArray3f((CGparameter)p, (long)0L, (long)(v.length / 3), (float[])v, (int)0);
        } else {
            System.err.println("(ShaderCGFX)  param3fv is null");
        }
    }

    public void setParameter4f(String param, float x, float y, float z, float w) {
        CGparameter p = null;
        p = CgGL.cgGetNamedEffectParameter((CGeffect)this._effect, (String)param);
        if (p != null) {
            CgGL.cgSetParameter4f((CGparameter)p, (float)x, (float)y, (float)z, (float)w);
        } else {
            System.err.println("(ShaderCGFX)  param4f is null");
        }
    }

    public void setParameter4fv(String param, float[] v) {
        CGparameter p = null;
        p = CgGL.cgGetNamedEffectParameter((CGeffect)this._effect, (String)param);
        if (p != null) {
            CgGL.cgGLSetParameterArray4f((CGparameter)p, (long)0L, (long)(v.length / 4), (float[])v, (int)0);
        } else {
            System.err.println("(ShaderCGFX)  param4fv is null");
        }
    }

    public void setMatrixParameterSemantic(String param, int matrix, int matrixType) {
        CGparameter p = null;
        p = CgGL.cgGetEffectParameterBySemantic((CGeffect)this._effect, (String)param);
        if (p != null) {
            CgGL.cgGLSetStateMatrixParameter((CGparameter)p, (int)matrix, (int)matrixType);
        } else {
            System.err.println("(ShaderCGFX)  setParameterSemantic(mat, type) is null");
        }
    }

    public void setMatrixParameterSemantic(String param, float[] v) {
        CGparameter p = null;
        p = CgGL.cgGetEffectParameterBySemantic((CGeffect)this._effect, (String)param);
        if (p != null) {
            CgGL.cgGLSetMatrixParameterfr((CGparameter)p, (float[])v, (int)0);
        } else {
            System.err.println("(ShaderCGFX)  setParameterSemantic(v[]) is null");
        }
    }

    public void setParameterSemantic(String param, float x) {
        CGparameter p = null;
        p = CgGL.cgGetNamedEffectParameter((CGeffect)this._effect, (String)param);
        if (p != null) {
            CgGL.cgSetParameter1f((CGparameter)p, (float)x);
        } else {
            System.err.println("(ShaderCGFX)  setParameterSemantic(x) is null");
        }
    }

    public void setParameterSemantic(String param, float x, float y) {
        CGparameter p = null;
        p = CgGL.cgGetNamedEffectParameter((CGeffect)this._effect, (String)param);
        if (p != null) {
            CgGL.cgSetParameter2f((CGparameter)p, (float)x, (float)y);
        } else {
            System.err.println("(ShaderCGFX)  setParameterSemantic(x, y) is null");
        }
    }

    public void setParameterSemantic(String param, float x, float y, float z) {
        CGparameter p = null;
        p = CgGL.cgGetNamedEffectParameter((CGeffect)this._effect, (String)param);
        if (p != null) {
            CgGL.cgSetParameter3f((CGparameter)p, (float)x, (float)y, (float)z);
        } else {
            System.err.println("(ShaderCGFX)  setParameterSemantic(x, y, z) is null");
        }
    }

    public void setParameterSemantic(String param, float x, float y, float z, float w) {
        CGparameter p = null;
        p = CgGL.cgGetNamedEffectParameter((CGeffect)this._effect, (String)param);
        if (p != null) {
            CgGL.cgSetParameter4f((CGparameter)p, (float)x, (float)y, (float)z, (float)w);
        } else {
            System.err.println("(ShaderCGFX)  setParameterSemantic(x, y, z, w) is null");
        }
    }

    public void setParameter4x4d(String param, double[] v) {
        CGparameter p = null;
        p = CgGL.cgGetNamedEffectParameter((CGeffect)this._effect, (String)param);
        if (p != null) {
            CgGL.cgSetMatrixParameterdr((CGparameter)p, (double[])v, (int)0);
        } else {
            System.err.println("(ShaderCGFX)  matrix4x4d param is null");
        }
    }

    public void setParameter4x4f(String param, float[] v) {
        CGparameter p = null;
        p = CgGL.cgGetNamedEffectParameter((CGeffect)this._effect, (String)param);
        if (p != null) {
            CgGL.cgGLSetMatrixParameterfr((CGparameter)p, (float[])v, (int)0);
        } else {
            System.err.println("(ShaderCGFX)  matrix4x4f param is null");
        }
    }

    public void setParameter4x4f(String param, int matrix, int matrixType) {
        CGparameter p = CgGL.cgGetNamedEffectParameter((CGeffect)this._effect, (String)param);
        if (p != null) {
            CgGL.cgGLSetStateMatrixParameter((CGparameter)p, (int)matrix, (int)matrixType);
        } else {
            System.err.println("(ShaderCGFX)  matrix4x4f semantic param is null");
        }
    }

    public void setParameter4x4fBySemantic(String semanticName, int matrix, int matrixType) {
        CGparameter p = CgGL.cgGetEffectParameterBySemantic((CGeffect)this._effect, (String)semanticName);
        if (p != null) {
            CgGL.cgGLSetStateMatrixParameter((CGparameter)p, (int)matrix, (int)matrixType);
        } else {
            System.err.println("(ShaderCGFX)  matrix4x4f semantic param is null");
        }
    }

    public boolean isPassValid() {
        return this._currPass != null;
    }
}

