#include <stdio.h>
#include <SDL.h>
#include <math.h>
#include <stdbool.h>
#include <stdint.h>

#define DRGB(r,g,b) (((r)<<16)|((g)<<8)|(b))
#define MULT (16)

// #define SAVE_TABS

int WIDTH = 256 * 2;
int HEIGHT = 192 * 2;
int PITCH;

SDL_Surface *screen;
unsigned long start;

void pixel(int x, int y, int c)
{
	if (x<0 || x>=256 || y<0 || y>=192) return;

	int* ptr = (int *)screen->pixels + PITCH*y*2 + x*2;

	*ptr = c;
	*(ptr + 1) = c;
	*(ptr + PITCH) = c;
	*(ptr + PITCH + 1) = c;
}

void clear()
{
	for (int i = 0; i < HEIGHT; i++)
	{
		int* line = (int *)screen->pixels + PITCH*i;

		for (int j = WIDTH; j--;) {
			(*(line++)) = DRGB(0, 0, 0);
		}
	}
}

int field[0x100];
int8_t s8_costab[0x100];

void prepare()
{
	for (int i = 0; i < 0x100; i++)
	{
		field[i] = ((i & 127) / 43) & 1;
		s8_costab[i] = (int8_t)(cos((float)i * M_PI / 128.0) * 127.0);
	}

#ifdef SAVE_TABS
	FILE *fp = fopen("costab.dat", "wb");

	if (fp != NULL)
	{
		if (fwrite(s8_costab, 0x100, 1, fp) != 0x100) {
			printf("oh nom nom\n");
		}

		fclose(fp);
	}
#endif
}

#include "chunks_1.h"
#include "chunks_2.h"
#include "chunks_3.h"
#include "chunks_4.h"
#include "chunks_5.h"
#include "chunks_6.h"

int (*chunks)[4][4] = chunks_1;

void draw_chunk(int x, int y, int c)
{
	x <<= 2;
	y <<= 2;

	for (int i = 0; i < 4; i++) {
		for (int j = 0; j < 4; j++) {
			if (chunks[c][i][j]) {
				pixel(x+j, y+i, DRGB(192, 0, 192));
			}
		}
	}
}

void draw(unsigned long tm)
{
	uint8_t pos = (uint8_t)((tm / (20 * 3)) << 2);
	// uint8_t pos = (uint8_t)(tm / 25);
	// uint8_t pos = (uint8_t)(tm / 1000);

	int8_t s8_cs = s8_costab[pos];
	int8_t s8_sn = s8_costab[(uint8_t)(pos + 64)];
	int16_t s16_cs_2 = (int16_t)s8_cs * 2;
	int16_t s16_sn_2 = (int16_t)s8_sn * 2;
	int16_t s16_xx = 0x4000 + 16 * s16_cs_2;
	int16_t s16_yy = 0x4000 + 16 * s16_sn_2;
	int16_t s16_zz = (int16_t)((uint8_t)(pos * 2 - 0x12)) * 0x100;
	int16_t s16_m_tmp = (int16_t)s8_cs;
	int16_t s16_w_tmp = (int16_t)s8_sn;

	int16_t s16_m = s16_sn_2 - s16_m_tmp;
	int16_t s16_um_tmp = s16_m * (int16_t)s8_cs / 128;
	int16_t s16_vm_tmp = s16_m * (int16_t)s8_sn / 128;
	//
	int16_t s16_w_tl = s16_cs_2 + s16_w_tmp;
	int16_t s16_u_tl = s16_um_tmp - s16_sn_2;
	int16_t s16_v_tl = - s16_cs_2 - s16_vm_tmp;
	int16_t s16_u_tr = s16_um_tmp + s16_sn_2;
	int16_t s16_v_tr = s16_cs_2 - s16_vm_tmp;

	s16_m = s16_sn_2 + s16_m_tmp;
	s16_um_tmp = s16_m * (int16_t)s8_cs / 128;
	s16_vm_tmp = s16_m * (int16_t)s8_sn / 128;
	//
	int16_t s16_w_bl = s16_cs_2 - s16_w_tmp;
	int16_t s16_u_bl = s16_um_tmp - s16_sn_2;
	int16_t s16_v_bl = - s16_cs_2 - s16_vm_tmp;
	int16_t s16_u_br = s16_um_tmp + s16_sn_2;
	int16_t s16_v_br = s16_cs_2 - s16_vm_tmp;

	int16_t s16_w_dl = (s16_w_bl - s16_w_tl);
	int16_t s16_u_dl = (s16_u_bl - s16_u_tl);
	int16_t s16_v_dl = (s16_v_bl - s16_v_tl);
	int16_t s16_u_dr = (s16_u_br - s16_u_tr);
	int16_t s16_v_dr = (s16_v_br - s16_v_tr);

	int16_t s16_w_l = s16_w_tl * 32;
	int16_t s16_u_l = s16_u_tl * 32;
	int16_t s16_v_l = s16_v_tl * 32;
	int16_t s16_u_r = s16_u_tr * 32;
	int16_t s16_v_r = s16_v_tr * 32;

	for (int cy = 0; cy < 32; cy++)
	{
		int16_t s16_uu = s16_u_l * 2;
		int16_t s16_vv = s16_v_l * 2;
		int16_t s16_w = s16_w_l / 32;
		int16_t s16_du = (s16_u_r - s16_u_l) / 32;
		int16_t s16_dv = (s16_v_r - s16_v_l) / 32;

		for (int cx = 0; cx < 64; cx++)
		{
			int16_t s16_u = s16_uu / 64;
			int16_t s16_v = s16_vv / 64;

			int16_t s16_x = s16_xx;
			int16_t s16_y = s16_yy;
			int16_t s16_z = s16_zz;
			int t = 127;

			while (t > 0)
			{
				uint8_t fx = (uint8_t)((uint16_t)s16_x >> 8);
				uint8_t fy = (uint8_t)((uint16_t)s16_y >> 8);
				uint8_t fz = (uint8_t)((uint16_t)s16_z >> 8);

				if (field[fx] + field[fy] + field[fz] < 2)
				{
					fx = fx + fx + fx;
					fy = fy + fy + fy;
					fz = fz + fz + fz;

					if (field[fx] + field[fy] + field[fz] < 2)
					{
						fx = fx + fx + fx;
						fy = fy + fy + fy;
						fz = fz + fz + fz;

						if (field[fx] + field[fy] + field[fz] < 2)
						{
							break;
						}
					}
				}

				s16_x += s16_u;
				s16_y += s16_v;
				s16_z += s16_w;
				t--;
			}

			draw_chunk(cx, cy + 8, t >> 3);

			s16_uu += s16_du;
			s16_vv += s16_dv;
		}

		s16_u_l += s16_u_dl;
		s16_v_l += s16_v_dl;
		s16_w_l += s16_w_dl;
		s16_u_r += s16_u_dr;
		s16_v_r += s16_v_dr;
	}
}

void process()
{
	if (SDL_MUSTLOCK(screen)) SDL_LockSurface(screen);

	unsigned long tm = SDL_GetTicks() - start;

	clear();
	draw(tm);

	if (SDL_MUSTLOCK(screen)) SDL_UnlockSurface(screen);
	SDL_UpdateRect(screen, 0, 0, 0, 0);
}

void loop()
{
	int key;
	SDL_Event event;

	start = SDL_GetTicks();

	for (;;)
	{
		process();

		while (SDL_PollEvent(&event))
		{
			if (event.type == SDL_QUIT) exit(0);

			if (event.type == SDL_KEYDOWN)
			{
				key = event.key.keysym.sym;

				switch (key)
				{
					case SDLK_ESCAPE:
						return;

					case '1':
						chunks = chunks_1;
						break;

					case '2':
						chunks = chunks_2;
						break;

					case '3':
						chunks = chunks_3;
						break;

					case '4':
						chunks = chunks_4;
						break;

					case '5':
						chunks = chunks_5;
						break;

					case '6':
						chunks = chunks_6;
						break;
				}
			}
		}

		SDL_Delay(1);
	}
}

int main(int argc, char** argv)
{
	if (SDL_Init(SDL_INIT_VIDEO) < 0)
	{
		printf("ERR:SDL_Init\n");
		return 0;
	}

	screen = SDL_SetVideoMode(WIDTH, HEIGHT, 32, SDL_SWSURFACE);

	if (!screen)
	{
		printf("ERR:SDL_SetVideoMode\n");
		return 0;
	}

	PITCH = screen->pitch / 4;

	prepare();
	loop();

	SDL_FreeSurface(screen);
}
